@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.kotlin.outputs.ApplicationPortalOptions
import com.pulumi.aws.ssoadmin.kotlin.outputs.ApplicationPortalOptions.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.aws.ssoadmin.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSO Admin Application.
 * > The `CreateApplication` API only supports custom OAuth 2.0 applications.
 * Creation of 3rd party SAML or OAuth 2.0 applications require setup to be done through the associated app service or AWS console.
 * See this issue for additional context.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleApplication = new aws.ssoadmin.Application("example", {
 *     name: "example",
 *     applicationProviderArn: "arn:aws:sso::aws:applicationProvider/custom",
 *     instanceArn: example.then(example => example.arns?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_application = aws.ssoadmin.Application("example",
 *     name="example",
 *     application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
 *     instance_arn=example.arns[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleApplication = new Aws.SsoAdmin.Application("example", new()
 *     {
 *         Name = "example",
 *         ApplicationProviderArn = "arn:aws:sso::aws:applicationProvider/custom",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewApplication(ctx, "example", &ssoadmin.ApplicationArgs{
 * 			Name:                   pulumi.String("example"),
 * 			ApplicationProviderArn: pulumi.String("arn:aws:sso::aws:applicationProvider/custom"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.Application;
 * import com.pulumi.aws.ssoadmin.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example")
 *             .applicationProviderArn("arn:aws:sso::aws:applicationProvider/custom")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleApplication:
 *     type: aws:ssoadmin:Application
 *     name: example
 *     properties:
 *       name: example
 *       applicationProviderArn: arn:aws:sso::aws:applicationProvider/custom
 *       instanceArn: ${example.arns[0]}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Portal Options
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleApplication = new aws.ssoadmin.Application("example", {
 *     name: "example",
 *     applicationProviderArn: "arn:aws:sso::aws:applicationProvider/custom",
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     portalOptions: {
 *         visibility: "ENABLED",
 *         signInOptions: {
 *             applicationUrl: "http://example.com",
 *             origin: "APPLICATION",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_application = aws.ssoadmin.Application("example",
 *     name="example",
 *     application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
 *     instance_arn=example.arns[0],
 *     portal_options={
 *         "visibility": "ENABLED",
 *         "sign_in_options": {
 *             "application_url": "http://example.com",
 *             "origin": "APPLICATION",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleApplication = new Aws.SsoAdmin.Application("example", new()
 *     {
 *         Name = "example",
 *         ApplicationProviderArn = "arn:aws:sso::aws:applicationProvider/custom",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         PortalOptions = new Aws.SsoAdmin.Inputs.ApplicationPortalOptionsArgs
 *         {
 *             Visibility = "ENABLED",
 *             SignInOptions = new Aws.SsoAdmin.Inputs.ApplicationPortalOptionsSignInOptionsArgs
 *             {
 *                 ApplicationUrl = "http://example.com",
 *                 Origin = "APPLICATION",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewApplication(ctx, "example", &ssoadmin.ApplicationArgs{
 * 			Name:                   pulumi.String("example"),
 * 			ApplicationProviderArn: pulumi.String("arn:aws:sso::aws:applicationProvider/custom"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 			PortalOptions: &ssoadmin.ApplicationPortalOptionsArgs{
 * 				Visibility: pulumi.String("ENABLED"),
 * 				SignInOptions: &ssoadmin.ApplicationPortalOptionsSignInOptionsArgs{
 * 					ApplicationUrl: pulumi.String("http://example.com"),
 * 					Origin:         pulumi.String("APPLICATION"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.Application;
 * import com.pulumi.aws.ssoadmin.ApplicationArgs;
 * import com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsArgs;
 * import com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsSignInOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example")
 *             .applicationProviderArn("arn:aws:sso::aws:applicationProvider/custom")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .portalOptions(ApplicationPortalOptionsArgs.builder()
 *                 .visibility("ENABLED")
 *                 .signInOptions(ApplicationPortalOptionsSignInOptionsArgs.builder()
 *                     .applicationUrl("http://example.com")
 *                     .origin("APPLICATION")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleApplication:
 *     type: aws:ssoadmin:Application
 *     name: example
 *     properties:
 *       name: example
 *       applicationProviderArn: arn:aws:sso::aws:applicationProvider/custom
 *       instanceArn: ${example.arns[0]}
 *       portalOptions:
 *         visibility: ENABLED
 *         signInOptions:
 *           applicationUrl: http://example.com
 *           origin: APPLICATION
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/application:Application example arn:aws:sso::012345678901:application/id-12345678
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * AWS account ID.
     */
    public val applicationAccount: Output<String>
        get() = javaResource.applicationAccount().applyValue({ args0 -> args0 })

    /**
     * ARN of the application.
     */
    public val applicationArn: Output<String>
        get() = javaResource.applicationArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the application provider.
     */
    public val applicationProviderArn: Output<String>
        get() = javaResource.applicationProviderArn().applyValue({ args0 -> args0 })

    /**
     * A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
     */
    public val clientToken: Output<String>?
        get() = javaResource.clientToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Description of the application.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the instance of IAM Identity Center.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * Name of the application.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Options for the portal associated with an application. See `portal_options` below.
     */
    public val portalOptions: Output<ApplicationPortalOptions>?
        get() = javaResource.portalOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Status of the application. Valid values are `ENABLED` and `DISABLED`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.aws.ssoadmin.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
