@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [ApplicationAccessScope].
 */
@PulumiTagMarker
public class ApplicationAccessScopeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationAccessScopeArgs = ApplicationAccessScopeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationAccessScopeArgsBuilder.() -> Unit) {
        val builder = ApplicationAccessScopeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationAccessScope {
        val builtJavaResource = com.pulumi.aws.ssoadmin.ApplicationAccessScope(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationAccessScope(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSO Admin Application Access Scope.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleApplication = new aws.ssoadmin.Application("example", {
 *     name: "example",
 *     applicationProviderArn: "arn:aws:sso::aws:applicationProvider/custom",
 *     instanceArn: example.then(example => example.arns?.[0]),
 * });
 * const exampleApplicationAccessScope = new aws.ssoadmin.ApplicationAccessScope("example", {
 *     applicationArn: exampleApplication.applicationArn,
 *     authorizedTargets: ["arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901"],
 *     scope: "sso:account:access",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_application = aws.ssoadmin.Application("example",
 *     name="example",
 *     application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
 *     instance_arn=example.arns[0])
 * example_application_access_scope = aws.ssoadmin.ApplicationAccessScope("example",
 *     application_arn=example_application.application_arn,
 *     authorized_targets=["arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901"],
 *     scope="sso:account:access")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleApplication = new Aws.SsoAdmin.Application("example", new()
 *     {
 *         Name = "example",
 *         ApplicationProviderArn = "arn:aws:sso::aws:applicationProvider/custom",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *     });
 *     var exampleApplicationAccessScope = new Aws.SsoAdmin.ApplicationAccessScope("example", new()
 *     {
 *         ApplicationArn = exampleApplication.ApplicationArn,
 *         AuthorizedTargets = new[]
 *         {
 *             "arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901",
 *         },
 *         Scope = "sso:account:access",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleApplication, err := ssoadmin.NewApplication(ctx, "example", &ssoadmin.ApplicationArgs{
 * 			Name:                   pulumi.String("example"),
 * 			ApplicationProviderArn: pulumi.String("arn:aws:sso::aws:applicationProvider/custom"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewApplicationAccessScope(ctx, "example", &ssoadmin.ApplicationAccessScopeArgs{
 * 			ApplicationArn: exampleApplication.ApplicationArn,
 * 			AuthorizedTargets: pulumi.StringArray{
 * 				pulumi.String("arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901"),
 * 			},
 * 			Scope: pulumi.String("sso:account:access"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.Application;
 * import com.pulumi.aws.ssoadmin.ApplicationArgs;
 * import com.pulumi.aws.ssoadmin.ApplicationAccessScope;
 * import com.pulumi.aws.ssoadmin.ApplicationAccessScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example")
 *             .applicationProviderArn("arn:aws:sso::aws:applicationProvider/custom")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .build());
 *         var exampleApplicationAccessScope = new ApplicationAccessScope("exampleApplicationAccessScope", ApplicationAccessScopeArgs.builder()
 *             .applicationArn(exampleApplication.applicationArn())
 *             .authorizedTargets("arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901")
 *             .scope("sso:account:access")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleApplication:
 *     type: aws:ssoadmin:Application
 *     name: example
 *     properties:
 *       name: example
 *       applicationProviderArn: arn:aws:sso::aws:applicationProvider/custom
 *       instanceArn: ${example.arns[0]}
 *   exampleApplicationAccessScope:
 *     type: aws:ssoadmin:ApplicationAccessScope
 *     name: example
 *     properties:
 *       applicationArn: ${exampleApplication.applicationArn}
 *       authorizedTargets:
 *         - arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901
 *       scope: sso:account:access
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application Access Scope using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/applicationAccessScope:ApplicationAccessScope example arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901,sso:account:access
 * ```
 */
public class ApplicationAccessScope internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.ApplicationAccessScope,
) : KotlinCustomResource(javaResource, ApplicationAccessScopeMapper) {
    /**
     * Specifies the ARN of the application with the access scope with the targets to add or update.
     */
    public val applicationArn: Output<String>
        get() = javaResource.applicationArn().applyValue({ args0 -> args0 })

    /**
     * Specifies an array list of ARNs that represent the authorized targets for this access scope.
     */
    public val authorizedTargets: Output<List<String>>?
        get() = javaResource.authorizedTargets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies the name of the access scope to be associated with the specified targets.
     * The following arguments are optional:
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })
}

public object ApplicationAccessScopeMapper : ResourceMapper<ApplicationAccessScope> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.ApplicationAccessScope::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationAccessScope =
        ApplicationAccessScope(javaResource as com.pulumi.aws.ssoadmin.ApplicationAccessScope)
}

/**
 * @see [ApplicationAccessScope].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationAccessScope].
 */
public suspend fun applicationAccessScope(
    name: String,
    block: suspend ApplicationAccessScopeResourceBuilder.() -> Unit,
): ApplicationAccessScope {
    val builder = ApplicationAccessScopeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationAccessScope].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationAccessScope(name: String): ApplicationAccessScope {
    val builder = ApplicationAccessScopeResourceBuilder()
    builder.name(name)
    return builder.build()
}
