@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.ApplicationAccessScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSO Admin Application Access Scope.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleApplication = new aws.ssoadmin.Application("example", {
 *     name: "example",
 *     applicationProviderArn: "arn:aws:sso::aws:applicationProvider/custom",
 *     instanceArn: example.then(example => example.arns?.[0]),
 * });
 * const exampleApplicationAccessScope = new aws.ssoadmin.ApplicationAccessScope("example", {
 *     applicationArn: exampleApplication.applicationArn,
 *     authorizedTargets: ["arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901"],
 *     scope: "sso:account:access",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_application = aws.ssoadmin.Application("example",
 *     name="example",
 *     application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
 *     instance_arn=example.arns[0])
 * example_application_access_scope = aws.ssoadmin.ApplicationAccessScope("example",
 *     application_arn=example_application.application_arn,
 *     authorized_targets=["arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901"],
 *     scope="sso:account:access")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleApplication = new Aws.SsoAdmin.Application("example", new()
 *     {
 *         Name = "example",
 *         ApplicationProviderArn = "arn:aws:sso::aws:applicationProvider/custom",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *     });
 *     var exampleApplicationAccessScope = new Aws.SsoAdmin.ApplicationAccessScope("example", new()
 *     {
 *         ApplicationArn = exampleApplication.ApplicationArn,
 *         AuthorizedTargets = new[]
 *         {
 *             "arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901",
 *         },
 *         Scope = "sso:account:access",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleApplication, err := ssoadmin.NewApplication(ctx, "example", &ssoadmin.ApplicationArgs{
 * 			Name:                   pulumi.String("example"),
 * 			ApplicationProviderArn: pulumi.String("arn:aws:sso::aws:applicationProvider/custom"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewApplicationAccessScope(ctx, "example", &ssoadmin.ApplicationAccessScopeArgs{
 * 			ApplicationArn: exampleApplication.ApplicationArn,
 * 			AuthorizedTargets: pulumi.StringArray{
 * 				pulumi.String("arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901"),
 * 			},
 * 			Scope: pulumi.String("sso:account:access"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.Application;
 * import com.pulumi.aws.ssoadmin.ApplicationArgs;
 * import com.pulumi.aws.ssoadmin.ApplicationAccessScope;
 * import com.pulumi.aws.ssoadmin.ApplicationAccessScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example")
 *             .applicationProviderArn("arn:aws:sso::aws:applicationProvider/custom")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .build());
 *         var exampleApplicationAccessScope = new ApplicationAccessScope("exampleApplicationAccessScope", ApplicationAccessScopeArgs.builder()
 *             .applicationArn(exampleApplication.applicationArn())
 *             .authorizedTargets("arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901")
 *             .scope("sso:account:access")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleApplication:
 *     type: aws:ssoadmin:Application
 *     name: example
 *     properties:
 *       name: example
 *       applicationProviderArn: arn:aws:sso::aws:applicationProvider/custom
 *       instanceArn: ${example.arns[0]}
 *   exampleApplicationAccessScope:
 *     type: aws:ssoadmin:ApplicationAccessScope
 *     name: example
 *     properties:
 *       applicationArn: ${exampleApplication.applicationArn}
 *       authorizedTargets:
 *         - arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901
 *       scope: sso:account:access
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application Access Scope using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/applicationAccessScope:ApplicationAccessScope example arn:aws:sso::012345678901:application/ssoins-012345678901/apl-012345678901,sso:account:access
 * ```
 * @property applicationArn Specifies the ARN of the application with the access scope with the targets to add or update.
 * @property authorizedTargets Specifies an array list of ARNs that represent the authorized targets for this access scope.
 * @property scope Specifies the name of the access scope to be associated with the specified targets.
 * The following arguments are optional:
 */
public data class ApplicationAccessScopeArgs(
    public val applicationArn: Output<String>? = null,
    public val authorizedTargets: Output<List<String>>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.ApplicationAccessScopeArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.ApplicationAccessScopeArgs =
        com.pulumi.aws.ssoadmin.ApplicationAccessScopeArgs.builder()
            .applicationArn(applicationArn?.applyValue({ args0 -> args0 }))
            .authorizedTargets(authorizedTargets?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationAccessScopeArgs].
 */
@PulumiTagMarker
public class ApplicationAccessScopeArgsBuilder internal constructor() {
    private var applicationArn: Output<String>? = null

    private var authorizedTargets: Output<List<String>>? = null

    private var scope: Output<String>? = null

    /**
     * @param value Specifies the ARN of the application with the access scope with the targets to add or update.
     */
    @JvmName("xesgerciijvhdcun")
    public suspend fun applicationArn(`value`: Output<String>) {
        this.applicationArn = value
    }

    /**
     * @param value Specifies an array list of ARNs that represent the authorized targets for this access scope.
     */
    @JvmName("xoivmtsddscbleku")
    public suspend fun authorizedTargets(`value`: Output<List<String>>) {
        this.authorizedTargets = value
    }

    @JvmName("gxojvetgosmelufg")
    public suspend fun authorizedTargets(vararg values: Output<String>) {
        this.authorizedTargets = Output.all(values.asList())
    }

    /**
     * @param values Specifies an array list of ARNs that represent the authorized targets for this access scope.
     */
    @JvmName("xtdcojgcaaihcgeg")
    public suspend fun authorizedTargets(values: List<Output<String>>) {
        this.authorizedTargets = Output.all(values)
    }

    /**
     * @param value Specifies the name of the access scope to be associated with the specified targets.
     * The following arguments are optional:
     */
    @JvmName("rgwexmmkndyliqsm")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value Specifies the ARN of the application with the access scope with the targets to add or update.
     */
    @JvmName("kummnvrshjhfnwdg")
    public suspend fun applicationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationArn = mapped
    }

    /**
     * @param value Specifies an array list of ARNs that represent the authorized targets for this access scope.
     */
    @JvmName("ulrpnqtekiagfdld")
    public suspend fun authorizedTargets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizedTargets = mapped
    }

    /**
     * @param values Specifies an array list of ARNs that represent the authorized targets for this access scope.
     */
    @JvmName("srgmlbmkgeghfokx")
    public suspend fun authorizedTargets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizedTargets = mapped
    }

    /**
     * @param value Specifies the name of the access scope to be associated with the specified targets.
     * The following arguments are optional:
     */
    @JvmName("xowxefhatucuvfnq")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): ApplicationAccessScopeArgs = ApplicationAccessScopeArgs(
        applicationArn = applicationArn,
        authorizedTargets = authorizedTargets,
        scope = scope,
    )
}
