@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.ApplicationArgs.builder
import com.pulumi.aws.ssoadmin.kotlin.inputs.ApplicationPortalOptionsArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.ApplicationPortalOptionsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSO Admin Application.
 * > The `CreateApplication` API only supports custom OAuth 2.0 applications.
 * Creation of 3rd party SAML or OAuth 2.0 applications require setup to be done through the associated app service or AWS console.
 * See this issue for additional context.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleApplication = new aws.ssoadmin.Application("example", {
 *     name: "example",
 *     applicationProviderArn: "arn:aws:sso::aws:applicationProvider/custom",
 *     instanceArn: example.then(example => example.arns?.[0]),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_application = aws.ssoadmin.Application("example",
 *     name="example",
 *     application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
 *     instance_arn=example.arns[0])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleApplication = new Aws.SsoAdmin.Application("example", new()
 *     {
 *         Name = "example",
 *         ApplicationProviderArn = "arn:aws:sso::aws:applicationProvider/custom",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewApplication(ctx, "example", &ssoadmin.ApplicationArgs{
 * 			Name:                   pulumi.String("example"),
 * 			ApplicationProviderArn: pulumi.String("arn:aws:sso::aws:applicationProvider/custom"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.Application;
 * import com.pulumi.aws.ssoadmin.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example")
 *             .applicationProviderArn("arn:aws:sso::aws:applicationProvider/custom")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleApplication:
 *     type: aws:ssoadmin:Application
 *     name: example
 *     properties:
 *       name: example
 *       applicationProviderArn: arn:aws:sso::aws:applicationProvider/custom
 *       instanceArn: ${example.arns[0]}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Portal Options
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleApplication = new aws.ssoadmin.Application("example", {
 *     name: "example",
 *     applicationProviderArn: "arn:aws:sso::aws:applicationProvider/custom",
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     portalOptions: {
 *         visibility: "ENABLED",
 *         signInOptions: {
 *             applicationUrl: "http://example.com",
 *             origin: "APPLICATION",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_application = aws.ssoadmin.Application("example",
 *     name="example",
 *     application_provider_arn="arn:aws:sso::aws:applicationProvider/custom",
 *     instance_arn=example.arns[0],
 *     portal_options={
 *         "visibility": "ENABLED",
 *         "sign_in_options": {
 *             "application_url": "http://example.com",
 *             "origin": "APPLICATION",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleApplication = new Aws.SsoAdmin.Application("example", new()
 *     {
 *         Name = "example",
 *         ApplicationProviderArn = "arn:aws:sso::aws:applicationProvider/custom",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         PortalOptions = new Aws.SsoAdmin.Inputs.ApplicationPortalOptionsArgs
 *         {
 *             Visibility = "ENABLED",
 *             SignInOptions = new Aws.SsoAdmin.Inputs.ApplicationPortalOptionsSignInOptionsArgs
 *             {
 *                 ApplicationUrl = "http://example.com",
 *                 Origin = "APPLICATION",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewApplication(ctx, "example", &ssoadmin.ApplicationArgs{
 * 			Name:                   pulumi.String("example"),
 * 			ApplicationProviderArn: pulumi.String("arn:aws:sso::aws:applicationProvider/custom"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 			PortalOptions: &ssoadmin.ApplicationPortalOptionsArgs{
 * 				Visibility: pulumi.String("ENABLED"),
 * 				SignInOptions: &ssoadmin.ApplicationPortalOptionsSignInOptionsArgs{
 * 					ApplicationUrl: pulumi.String("http://example.com"),
 * 					Origin:         pulumi.String("APPLICATION"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.Application;
 * import com.pulumi.aws.ssoadmin.ApplicationArgs;
 * import com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsArgs;
 * import com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsSignInOptionsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleApplication = new Application("exampleApplication", ApplicationArgs.builder()
 *             .name("example")
 *             .applicationProviderArn("arn:aws:sso::aws:applicationProvider/custom")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .portalOptions(ApplicationPortalOptionsArgs.builder()
 *                 .visibility("ENABLED")
 *                 .signInOptions(ApplicationPortalOptionsSignInOptionsArgs.builder()
 *                     .applicationUrl("http://example.com")
 *                     .origin("APPLICATION")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleApplication:
 *     type: aws:ssoadmin:Application
 *     name: example
 *     properties:
 *       name: example
 *       applicationProviderArn: arn:aws:sso::aws:applicationProvider/custom
 *       instanceArn: ${example.arns[0]}
 *       portalOptions:
 *         visibility: ENABLED
 *         signInOptions:
 *           applicationUrl: http://example.com
 *           origin: APPLICATION
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/application:Application example arn:aws:sso::012345678901:application/id-12345678
 * ```
 * @property applicationProviderArn ARN of the application provider.
 * @property clientToken A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
 * @property description Description of the application.
 * @property instanceArn ARN of the instance of IAM Identity Center.
 * @property name Name of the application.
 * The following arguments are optional:
 * @property portalOptions Options for the portal associated with an application. See `portal_options` below.
 * @property status Status of the application. Valid values are `ENABLED` and `DISABLED`.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ApplicationArgs(
    public val applicationProviderArn: Output<String>? = null,
    public val clientToken: Output<String>? = null,
    public val description: Output<String>? = null,
    public val instanceArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val portalOptions: Output<ApplicationPortalOptionsArgs>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.ApplicationArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.ApplicationArgs =
        com.pulumi.aws.ssoadmin.ApplicationArgs.builder()
            .applicationProviderArn(applicationProviderArn?.applyValue({ args0 -> args0 }))
            .clientToken(clientToken?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .portalOptions(portalOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationProviderArn: Output<String>? = null

    private var clientToken: Output<String>? = null

    private var description: Output<String>? = null

    private var instanceArn: Output<String>? = null

    private var name: Output<String>? = null

    private var portalOptions: Output<ApplicationPortalOptionsArgs>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ARN of the application provider.
     */
    @JvmName("ipyrsixfwwrctxhc")
    public suspend fun applicationProviderArn(`value`: Output<String>) {
        this.applicationProviderArn = value
    }

    /**
     * @param value A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
     */
    @JvmName("eleiluldurtbkhgo")
    public suspend fun clientToken(`value`: Output<String>) {
        this.clientToken = value
    }

    /**
     * @param value Description of the application.
     */
    @JvmName("pfjnaaeknqjeayrq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value ARN of the instance of IAM Identity Center.
     */
    @JvmName("nbnubyrhybqoefar")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value Name of the application.
     * The following arguments are optional:
     */
    @JvmName("ljxowsnsuwlmqhow")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Options for the portal associated with an application. See `portal_options` below.
     */
    @JvmName("nupaulkkdnrlqeaa")
    public suspend fun portalOptions(`value`: Output<ApplicationPortalOptionsArgs>) {
        this.portalOptions = value
    }

    /**
     * @param value Status of the application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("gjhiicvprrxbjoax")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ahjfoumphphhtver")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARN of the application provider.
     */
    @JvmName("mrolodkgufodxway")
    public suspend fun applicationProviderArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationProviderArn = mapped
    }

    /**
     * @param value A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
     */
    @JvmName("tmohivygpttgmymb")
    public suspend fun clientToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientToken = mapped
    }

    /**
     * @param value Description of the application.
     */
    @JvmName("odbwhucjjgsthsrl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value ARN of the instance of IAM Identity Center.
     */
    @JvmName("dtoiikfbnwuqlqih")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value Name of the application.
     * The following arguments are optional:
     */
    @JvmName("pxergmhyelwiwfvk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Options for the portal associated with an application. See `portal_options` below.
     */
    @JvmName("thkvqblseapuuchu")
    public suspend fun portalOptions(`value`: ApplicationPortalOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.portalOptions = mapped
    }

    /**
     * @param argument Options for the portal associated with an application. See `portal_options` below.
     */
    @JvmName("isclibmxndmikpub")
    public suspend fun portalOptions(argument: suspend ApplicationPortalOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationPortalOptionsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.portalOptions = mapped
    }

    /**
     * @param value Status of the application. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("adhlqdbwygsaxpwq")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eptkrcdihtlacygk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("issokfictgkgykgo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationProviderArn = applicationProviderArn,
        clientToken = clientToken,
        description = description,
        instanceArn = instanceArn,
        name = name,
        portalOptions = portalOptions,
        status = status,
        tags = tags,
    )
}
