@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApplicationAssignment].
 */
@PulumiTagMarker
public class ApplicationAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationAssignmentArgs = ApplicationAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationAssignmentArgsBuilder.() -> Unit) {
        val builder = ApplicationAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationAssignment {
        val builtJavaResource = com.pulumi.aws.ssoadmin.ApplicationAssignment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ApplicationAssignment(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSO Admin Application Assignment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssoadmin.ApplicationAssignment("example", {
 *     applicationArn: exampleAwsSsoadminApplication.applicationArn,
 *     principalId: exampleAwsIdentitystoreUser.userId,
 *     principalType: "USER",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.ApplicationAssignment("example",
 *     application_arn=example_aws_ssoadmin_application["applicationArn"],
 *     principal_id=example_aws_identitystore_user["userId"],
 *     principal_type="USER")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsoAdmin.ApplicationAssignment("example", new()
 *     {
 *         ApplicationArn = exampleAwsSsoadminApplication.ApplicationArn,
 *         PrincipalId = exampleAwsIdentitystoreUser.UserId,
 *         PrincipalType = "USER",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssoadmin.NewApplicationAssignment(ctx, "example", &ssoadmin.ApplicationAssignmentArgs{
 * 			ApplicationArn: pulumi.Any(exampleAwsSsoadminApplication.ApplicationArn),
 * 			PrincipalId:    pulumi.Any(exampleAwsIdentitystoreUser.UserId),
 * 			PrincipalType:  pulumi.String("USER"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignment;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationAssignment("example", ApplicationAssignmentArgs.builder()
 *             .applicationArn(exampleAwsSsoadminApplication.applicationArn())
 *             .principalId(exampleAwsIdentitystoreUser.userId())
 *             .principalType("USER")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssoadmin:ApplicationAssignment
 *     properties:
 *       applicationArn: ${exampleAwsSsoadminApplication.applicationArn}
 *       principalId: ${exampleAwsIdentitystoreUser.userId}
 *       principalType: USER
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Group Type
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssoadmin.ApplicationAssignment("example", {
 *     applicationArn: exampleAwsSsoadminApplication.applicationArn,
 *     principalId: exampleAwsIdentitystoreGroup.groupId,
 *     principalType: "GROUP",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.ApplicationAssignment("example",
 *     application_arn=example_aws_ssoadmin_application["applicationArn"],
 *     principal_id=example_aws_identitystore_group["groupId"],
 *     principal_type="GROUP")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsoAdmin.ApplicationAssignment("example", new()
 *     {
 *         ApplicationArn = exampleAwsSsoadminApplication.ApplicationArn,
 *         PrincipalId = exampleAwsIdentitystoreGroup.GroupId,
 *         PrincipalType = "GROUP",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssoadmin.NewApplicationAssignment(ctx, "example", &ssoadmin.ApplicationAssignmentArgs{
 * 			ApplicationArn: pulumi.Any(exampleAwsSsoadminApplication.ApplicationArn),
 * 			PrincipalId:    pulumi.Any(exampleAwsIdentitystoreGroup.GroupId),
 * 			PrincipalType:  pulumi.String("GROUP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignment;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationAssignment("example", ApplicationAssignmentArgs.builder()
 *             .applicationArn(exampleAwsSsoadminApplication.applicationArn())
 *             .principalId(exampleAwsIdentitystoreGroup.groupId())
 *             .principalType("GROUP")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssoadmin:ApplicationAssignment
 *     properties:
 *       applicationArn: ${exampleAwsSsoadminApplication.applicationArn}
 *       principalId: ${exampleAwsIdentitystoreGroup.groupId}
 *       principalType: GROUP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application Assignment using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/applicationAssignment:ApplicationAssignment example arn:aws:sso::012345678901:application/id-12345678,abcd1234,USER
 * ```
 */
public class ApplicationAssignment internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.ApplicationAssignment,
) : KotlinCustomResource(javaResource, ApplicationAssignmentMapper) {
    /**
     * ARN of the application.
     */
    public val applicationArn: Output<String>
        get() = javaResource.applicationArn().applyValue({ args0 -> args0 })

    /**
     * An identifier for an object in IAM Identity Center, such as a user or group.
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })
}

public object ApplicationAssignmentMapper : ResourceMapper<ApplicationAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.ApplicationAssignment::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationAssignment =
        ApplicationAssignment(javaResource as com.pulumi.aws.ssoadmin.ApplicationAssignment)
}

/**
 * @see [ApplicationAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationAssignment].
 */
public suspend fun applicationAssignment(
    name: String,
    block: suspend ApplicationAssignmentResourceBuilder.() -> Unit,
): ApplicationAssignment {
    val builder = ApplicationAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationAssignment(name: String): ApplicationAssignment {
    val builder = ApplicationAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
