@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSO Admin Application Assignment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssoadmin.ApplicationAssignment("example", {
 *     applicationArn: exampleAwsSsoadminApplication.applicationArn,
 *     principalId: exampleAwsIdentitystoreUser.userId,
 *     principalType: "USER",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.ApplicationAssignment("example",
 *     application_arn=example_aws_ssoadmin_application["applicationArn"],
 *     principal_id=example_aws_identitystore_user["userId"],
 *     principal_type="USER")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsoAdmin.ApplicationAssignment("example", new()
 *     {
 *         ApplicationArn = exampleAwsSsoadminApplication.ApplicationArn,
 *         PrincipalId = exampleAwsIdentitystoreUser.UserId,
 *         PrincipalType = "USER",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssoadmin.NewApplicationAssignment(ctx, "example", &ssoadmin.ApplicationAssignmentArgs{
 * 			ApplicationArn: pulumi.Any(exampleAwsSsoadminApplication.ApplicationArn),
 * 			PrincipalId:    pulumi.Any(exampleAwsIdentitystoreUser.UserId),
 * 			PrincipalType:  pulumi.String("USER"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignment;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationAssignment("example", ApplicationAssignmentArgs.builder()
 *             .applicationArn(exampleAwsSsoadminApplication.applicationArn())
 *             .principalId(exampleAwsIdentitystoreUser.userId())
 *             .principalType("USER")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssoadmin:ApplicationAssignment
 *     properties:
 *       applicationArn: ${exampleAwsSsoadminApplication.applicationArn}
 *       principalId: ${exampleAwsIdentitystoreUser.userId}
 *       principalType: USER
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Group Type
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssoadmin.ApplicationAssignment("example", {
 *     applicationArn: exampleAwsSsoadminApplication.applicationArn,
 *     principalId: exampleAwsIdentitystoreGroup.groupId,
 *     principalType: "GROUP",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.ApplicationAssignment("example",
 *     application_arn=example_aws_ssoadmin_application["applicationArn"],
 *     principal_id=example_aws_identitystore_group["groupId"],
 *     principal_type="GROUP")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsoAdmin.ApplicationAssignment("example", new()
 *     {
 *         ApplicationArn = exampleAwsSsoadminApplication.ApplicationArn,
 *         PrincipalId = exampleAwsIdentitystoreGroup.GroupId,
 *         PrincipalType = "GROUP",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssoadmin.NewApplicationAssignment(ctx, "example", &ssoadmin.ApplicationAssignmentArgs{
 * 			ApplicationArn: pulumi.Any(exampleAwsSsoadminApplication.ApplicationArn),
 * 			PrincipalId:    pulumi.Any(exampleAwsIdentitystoreGroup.GroupId),
 * 			PrincipalType:  pulumi.String("GROUP"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignment;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationAssignment("example", ApplicationAssignmentArgs.builder()
 *             .applicationArn(exampleAwsSsoadminApplication.applicationArn())
 *             .principalId(exampleAwsIdentitystoreGroup.groupId())
 *             .principalType("GROUP")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssoadmin:ApplicationAssignment
 *     properties:
 *       applicationArn: ${exampleAwsSsoadminApplication.applicationArn}
 *       principalId: ${exampleAwsIdentitystoreGroup.groupId}
 *       principalType: GROUP
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application Assignment using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/applicationAssignment:ApplicationAssignment example arn:aws:sso::012345678901:application/id-12345678,abcd1234,USER
 * ```
 * @property applicationArn ARN of the application.
 * @property principalId An identifier for an object in IAM Identity Center, such as a user or group.
 * @property principalType Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
 */
public data class ApplicationAssignmentArgs(
    public val applicationArn: Output<String>? = null,
    public val principalId: Output<String>? = null,
    public val principalType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs =
        com.pulumi.aws.ssoadmin.ApplicationAssignmentArgs.builder()
            .applicationArn(applicationArn?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 }))
            .principalType(principalType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationAssignmentArgs].
 */
@PulumiTagMarker
public class ApplicationAssignmentArgsBuilder internal constructor() {
    private var applicationArn: Output<String>? = null

    private var principalId: Output<String>? = null

    private var principalType: Output<String>? = null

    /**
     * @param value ARN of the application.
     */
    @JvmName("yajyduxykfdvdyvi")
    public suspend fun applicationArn(`value`: Output<String>) {
        this.applicationArn = value
    }

    /**
     * @param value An identifier for an object in IAM Identity Center, such as a user or group.
     */
    @JvmName("yybcblkbccubskwc")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
     */
    @JvmName("vcxspjitshwtygjr")
    public suspend fun principalType(`value`: Output<String>) {
        this.principalType = value
    }

    /**
     * @param value ARN of the application.
     */
    @JvmName("hutlqyirlpgqlfwi")
    public suspend fun applicationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationArn = mapped
    }

    /**
     * @param value An identifier for an object in IAM Identity Center, such as a user or group.
     */
    @JvmName("mcqhwfrqtekvmwiu")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
     */
    @JvmName("admfajfbeqndnehv")
    public suspend fun principalType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    internal fun build(): ApplicationAssignmentArgs = ApplicationAssignmentArgs(
        applicationArn = applicationArn,
        principalId = principalId,
        principalType = principalType,
    )
}
