@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ApplicationAssignmentConfiguration].
 */
@PulumiTagMarker
public class ApplicationAssignmentConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationAssignmentConfigurationArgs = ApplicationAssignmentConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationAssignmentConfigurationArgsBuilder.() -> Unit) {
        val builder = ApplicationAssignmentConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ApplicationAssignmentConfiguration {
        val builtJavaResource =
            com.pulumi.aws.ssoadmin.ApplicationAssignmentConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ApplicationAssignmentConfiguration(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSO Admin Application Assignment Configuration.
 * By default, applications will require users to have an explicit assignment in order to access an application.
 * This resource can be used to adjust this default behavior if necessary.
 * > Deleting this resource will return the assignment configuration for the application to the default AWS behavior (ie. `assignment_required = true`).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssoadmin.ApplicationAssignmentConfiguration("example", {
 *     applicationArn: exampleAwsSsoadminApplication.applicationArn,
 *     assignmentRequired: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.ApplicationAssignmentConfiguration("example",
 *     application_arn=example_aws_ssoadmin_application["applicationArn"],
 *     assignment_required=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsoAdmin.ApplicationAssignmentConfiguration("example", new()
 *     {
 *         ApplicationArn = exampleAwsSsoadminApplication.ApplicationArn,
 *         AssignmentRequired = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssoadmin.NewApplicationAssignmentConfiguration(ctx, "example", &ssoadmin.ApplicationAssignmentConfigurationArgs{
 * 			ApplicationArn:     pulumi.Any(exampleAwsSsoadminApplication.ApplicationArn),
 * 			AssignmentRequired: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentConfiguration;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationAssignmentConfiguration("example", ApplicationAssignmentConfigurationArgs.builder()
 *             .applicationArn(exampleAwsSsoadminApplication.applicationArn())
 *             .assignmentRequired(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssoadmin:ApplicationAssignmentConfiguration
 *     properties:
 *       applicationArn: ${exampleAwsSsoadminApplication.applicationArn}
 *       assignmentRequired: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application Assignment Configuration using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/applicationAssignmentConfiguration:ApplicationAssignmentConfiguration example arn:aws:sso::012345678901:application/id-12345678
 * ```
 */
public class ApplicationAssignmentConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.ApplicationAssignmentConfiguration,
) : KotlinCustomResource(javaResource, ApplicationAssignmentConfigurationMapper) {
    /**
     * ARN of the application.
     */
    public val applicationArn: Output<String>
        get() = javaResource.applicationArn().applyValue({ args0 -> args0 })

    /**
     * Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
     */
    public val assignmentRequired: Output<Boolean>
        get() = javaResource.assignmentRequired().applyValue({ args0 -> args0 })
}

public object ApplicationAssignmentConfigurationMapper :
    ResourceMapper<ApplicationAssignmentConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.ApplicationAssignmentConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ApplicationAssignmentConfiguration =
        ApplicationAssignmentConfiguration(
            javaResource as
                com.pulumi.aws.ssoadmin.ApplicationAssignmentConfiguration,
        )
}

/**
 * @see [ApplicationAssignmentConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ApplicationAssignmentConfiguration].
 */
public suspend fun applicationAssignmentConfiguration(
    name: String,
    block: suspend ApplicationAssignmentConfigurationResourceBuilder.() -> Unit,
): ApplicationAssignmentConfiguration {
    val builder = ApplicationAssignmentConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ApplicationAssignmentConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun applicationAssignmentConfiguration(name: String): ApplicationAssignmentConfiguration {
    val builder = ApplicationAssignmentConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
