@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.ApplicationAssignmentConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSO Admin Application Assignment Configuration.
 * By default, applications will require users to have an explicit assignment in order to access an application.
 * This resource can be used to adjust this default behavior if necessary.
 * > Deleting this resource will return the assignment configuration for the application to the default AWS behavior (ie. `assignment_required = true`).
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssoadmin.ApplicationAssignmentConfiguration("example", {
 *     applicationArn: exampleAwsSsoadminApplication.applicationArn,
 *     assignmentRequired: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.ApplicationAssignmentConfiguration("example",
 *     application_arn=example_aws_ssoadmin_application["applicationArn"],
 *     assignment_required=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsoAdmin.ApplicationAssignmentConfiguration("example", new()
 *     {
 *         ApplicationArn = exampleAwsSsoadminApplication.ApplicationArn,
 *         AssignmentRequired = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssoadmin.NewApplicationAssignmentConfiguration(ctx, "example", &ssoadmin.ApplicationAssignmentConfigurationArgs{
 * 			ApplicationArn:     pulumi.Any(exampleAwsSsoadminApplication.ApplicationArn),
 * 			AssignmentRequired: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentConfiguration;
 * import com.pulumi.aws.ssoadmin.ApplicationAssignmentConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ApplicationAssignmentConfiguration("example", ApplicationAssignmentConfigurationArgs.builder()
 *             .applicationArn(exampleAwsSsoadminApplication.applicationArn())
 *             .assignmentRequired(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssoadmin:ApplicationAssignmentConfiguration
 *     properties:
 *       applicationArn: ${exampleAwsSsoadminApplication.applicationArn}
 *       assignmentRequired: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Application Assignment Configuration using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/applicationAssignmentConfiguration:ApplicationAssignmentConfiguration example arn:aws:sso::012345678901:application/id-12345678
 * ```
 * @property applicationArn ARN of the application.
 * @property assignmentRequired Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
 */
public data class ApplicationAssignmentConfigurationArgs(
    public val applicationArn: Output<String>? = null,
    public val assignmentRequired: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.ApplicationAssignmentConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.ApplicationAssignmentConfigurationArgs =
        com.pulumi.aws.ssoadmin.ApplicationAssignmentConfigurationArgs.builder()
            .applicationArn(applicationArn?.applyValue({ args0 -> args0 }))
            .assignmentRequired(assignmentRequired?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationAssignmentConfigurationArgs].
 */
@PulumiTagMarker
public class ApplicationAssignmentConfigurationArgsBuilder internal constructor() {
    private var applicationArn: Output<String>? = null

    private var assignmentRequired: Output<Boolean>? = null

    /**
     * @param value ARN of the application.
     */
    @JvmName("qpoaqltxbvhlmlva")
    public suspend fun applicationArn(`value`: Output<String>) {
        this.applicationArn = value
    }

    /**
     * @param value Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
     */
    @JvmName("acbobxwmronmysig")
    public suspend fun assignmentRequired(`value`: Output<Boolean>) {
        this.assignmentRequired = value
    }

    /**
     * @param value ARN of the application.
     */
    @JvmName("bdwrupmnqsguiykt")
    public suspend fun applicationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationArn = mapped
    }

    /**
     * @param value Indicates whether users must have an explicit assignment to access the application. If `false`, all users have access to the application.
     */
    @JvmName("oubeuiytblkexkvc")
    public suspend fun assignmentRequired(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentRequired = mapped
    }

    internal fun build(): ApplicationAssignmentConfigurationArgs =
        ApplicationAssignmentConfigurationArgs(
            applicationArn = applicationArn,
            assignmentRequired = assignmentRequired,
        )
}
