@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.kotlin.outputs.InstanceAccessControlAttributesAttribute
import com.pulumi.aws.ssoadmin.kotlin.outputs.InstanceAccessControlAttributesAttribute.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [InstanceAccessControlAttributes].
 */
@PulumiTagMarker
public class InstanceAccessControlAttributesResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InstanceAccessControlAttributesArgs = InstanceAccessControlAttributesArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InstanceAccessControlAttributesArgsBuilder.() -> Unit) {
        val builder = InstanceAccessControlAttributesArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): InstanceAccessControlAttributes {
        val builtJavaResource =
            com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InstanceAccessControlAttributes(builtJavaResource)
    }
}

/**
 * Provides a Single Sign-On (SSO) ABAC Resource: https://docs.aws.amazon.com/singlesignon/latest/userguide/abac.html
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleInstanceAccessControlAttributes = new aws.ssoadmin.InstanceAccessControlAttributes("example", {
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     attributes: [
 *         {
 *             key: "name",
 *             values: [{
 *                 sources: ["${path:name&#46;givenName}"],
 *             }],
 *         },
 *         {
 *             key: "last",
 *             values: [{
 *                 sources: ["${path:name&#46;familyName}"],
 *             }],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_instance_access_control_attributes = aws.ssoadmin.InstanceAccessControlAttributes("example",
 *     instance_arn=example.arns[0],
 *     attributes=[
 *         {
 *             "key": "name",
 *             "values": [{
 *                 "sources": ["${path:name&#46;givenName}"],
 *             }],
 *         },
 *         {
 *             "key": "last",
 *             "values": [{
 *                 "sources": ["${path:name&#46;familyName}"],
 *             }],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleInstanceAccessControlAttributes = new Aws.SsoAdmin.InstanceAccessControlAttributes("example", new()
 *     {
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         Attributes = new[]
 *         {
 *             new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeArgs
 *             {
 *                 Key = "name",
 *                 Values = new[]
 *                 {
 *                     new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeValueArgs
 *                     {
 *                         Sources = new[]
 *                         {
 *                             "${path:name.givenName}",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeArgs
 *             {
 *                 Key = "last",
 *                 Values = new[]
 *                 {
 *                     new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeValueArgs
 *                     {
 *                         Sources = new[]
 *                         {
 *                             "${path:name.familyName}",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewInstanceAccessControlAttributes(ctx, "example", &ssoadmin.InstanceAccessControlAttributesArgs{
 * 			InstanceArn: pulumi.String(example.Arns[0]),
 * 			Attributes: ssoadmin.InstanceAccessControlAttributesAttributeArray{
 * 				&ssoadmin.InstanceAccessControlAttributesAttributeArgs{
 * 					Key: pulumi.String("name"),
 * 					Values: ssoadmin.InstanceAccessControlAttributesAttributeValueArray{
 * 						&ssoadmin.InstanceAccessControlAttributesAttributeValueArgs{
 * 							Sources: pulumi.StringArray{
 * 								pulumi.String("${path:name.givenName}"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&ssoadmin.InstanceAccessControlAttributesAttributeArgs{
 * 					Key: pulumi.String("last"),
 * 					Values: ssoadmin.InstanceAccessControlAttributesAttributeValueArray{
 * 						&ssoadmin.InstanceAccessControlAttributesAttributeValueArgs{
 * 							Sources: pulumi.StringArray{
 * 								pulumi.String("${path:name.familyName}"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes;
 * import com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs;
 * import com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleInstanceAccessControlAttributes = new InstanceAccessControlAttributes("exampleInstanceAccessControlAttributes", InstanceAccessControlAttributesArgs.builder()
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .attributes(
 *                 InstanceAccessControlAttributesAttributeArgs.builder()
 *                     .key("name")
 *                     .values(InstanceAccessControlAttributesAttributeValueArgs.builder()
 *                         .sources("${path:name.givenName}")
 *                         .build())
 *                     .build(),
 *                 InstanceAccessControlAttributesAttributeArgs.builder()
 *                     .key("last")
 *                     .values(InstanceAccessControlAttributesAttributeValueArgs.builder()
 *                         .sources("${path:name.familyName}")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleInstanceAccessControlAttributes:
 *     type: aws:ssoadmin:InstanceAccessControlAttributes
 *     name: example
 *     properties:
 *       instanceArn: ${example.arns[0]}
 *       attributes:
 *         - key: name
 *           values:
 *             - sources:
 *                 - ${path:name.givenName}
 *         - key: last
 *           values:
 *             - sources:
 *                 - ${path:name.familyName}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Account Assignments using the `instance_arn`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/instanceAccessControlAttributes:InstanceAccessControlAttributes example arn:aws:sso:::instance/ssoins-0123456789abcdef
 * ```
 */
public class InstanceAccessControlAttributes internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes,
) : KotlinCustomResource(javaResource, InstanceAccessControlAttributesMapper) {
    /**
     * See AccessControlAttribute for more details.
     */
    public val attributes: Output<List<InstanceAccessControlAttributesAttribute>>
        get() = javaResource.attributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * The Amazon Resource Name (ARN) of the SSO Instance.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val statusReason: Output<String>
        get() = javaResource.statusReason().applyValue({ args0 -> args0 })
}

public object InstanceAccessControlAttributesMapper :
    ResourceMapper<InstanceAccessControlAttributes> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes::class == javaResource::class

    override fun map(javaResource: Resource): InstanceAccessControlAttributes =
        InstanceAccessControlAttributes(
            javaResource as
                com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes,
        )
}

/**
 * @see [InstanceAccessControlAttributes].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InstanceAccessControlAttributes].
 */
public suspend fun instanceAccessControlAttributes(
    name: String,
    block: suspend InstanceAccessControlAttributesResourceBuilder.() -> Unit,
): InstanceAccessControlAttributes {
    val builder = InstanceAccessControlAttributesResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InstanceAccessControlAttributes].
 * @param name The _unique_ name of the resulting resource.
 */
public fun instanceAccessControlAttributes(name: String): InstanceAccessControlAttributes {
    val builder = InstanceAccessControlAttributesResourceBuilder()
    builder.name(name)
    return builder.build()
}
