@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs.builder
import com.pulumi.aws.ssoadmin.kotlin.inputs.InstanceAccessControlAttributesAttributeArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.InstanceAccessControlAttributesAttributeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Single Sign-On (SSO) ABAC Resource: https://docs.aws.amazon.com/singlesignon/latest/userguide/abac.html
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleInstanceAccessControlAttributes = new aws.ssoadmin.InstanceAccessControlAttributes("example", {
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     attributes: [
 *         {
 *             key: "name",
 *             values: [{
 *                 sources: ["${path:name&#46;givenName}"],
 *             }],
 *         },
 *         {
 *             key: "last",
 *             values: [{
 *                 sources: ["${path:name&#46;familyName}"],
 *             }],
 *         },
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_instance_access_control_attributes = aws.ssoadmin.InstanceAccessControlAttributes("example",
 *     instance_arn=example.arns[0],
 *     attributes=[
 *         {
 *             "key": "name",
 *             "values": [{
 *                 "sources": ["${path:name&#46;givenName}"],
 *             }],
 *         },
 *         {
 *             "key": "last",
 *             "values": [{
 *                 "sources": ["${path:name&#46;familyName}"],
 *             }],
 *         },
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleInstanceAccessControlAttributes = new Aws.SsoAdmin.InstanceAccessControlAttributes("example", new()
 *     {
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         Attributes = new[]
 *         {
 *             new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeArgs
 *             {
 *                 Key = "name",
 *                 Values = new[]
 *                 {
 *                     new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeValueArgs
 *                     {
 *                         Sources = new[]
 *                         {
 *                             "${path:name.givenName}",
 *                         },
 *                     },
 *                 },
 *             },
 *             new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeArgs
 *             {
 *                 Key = "last",
 *                 Values = new[]
 *                 {
 *                     new Aws.SsoAdmin.Inputs.InstanceAccessControlAttributesAttributeValueArgs
 *                     {
 *                         Sources = new[]
 *                         {
 *                             "${path:name.familyName}",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewInstanceAccessControlAttributes(ctx, "example", &ssoadmin.InstanceAccessControlAttributesArgs{
 * 			InstanceArn: pulumi.String(example.Arns[0]),
 * 			Attributes: ssoadmin.InstanceAccessControlAttributesAttributeArray{
 * 				&ssoadmin.InstanceAccessControlAttributesAttributeArgs{
 * 					Key: pulumi.String("name"),
 * 					Values: ssoadmin.InstanceAccessControlAttributesAttributeValueArray{
 * 						&ssoadmin.InstanceAccessControlAttributesAttributeValueArgs{
 * 							Sources: pulumi.StringArray{
 * 								pulumi.String("${path:name.givenName}"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				&ssoadmin.InstanceAccessControlAttributesAttributeArgs{
 * 					Key: pulumi.String("last"),
 * 					Values: ssoadmin.InstanceAccessControlAttributesAttributeValueArray{
 * 						&ssoadmin.InstanceAccessControlAttributesAttributeValueArgs{
 * 							Sources: pulumi.StringArray{
 * 								pulumi.String("${path:name.familyName}"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.InstanceAccessControlAttributes;
 * import com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs;
 * import com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleInstanceAccessControlAttributes = new InstanceAccessControlAttributes("exampleInstanceAccessControlAttributes", InstanceAccessControlAttributesArgs.builder()
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .attributes(
 *                 InstanceAccessControlAttributesAttributeArgs.builder()
 *                     .key("name")
 *                     .values(InstanceAccessControlAttributesAttributeValueArgs.builder()
 *                         .sources("${path:name.givenName}")
 *                         .build())
 *                     .build(),
 *                 InstanceAccessControlAttributesAttributeArgs.builder()
 *                     .key("last")
 *                     .values(InstanceAccessControlAttributesAttributeValueArgs.builder()
 *                         .sources("${path:name.familyName}")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleInstanceAccessControlAttributes:
 *     type: aws:ssoadmin:InstanceAccessControlAttributes
 *     name: example
 *     properties:
 *       instanceArn: ${example.arns[0]}
 *       attributes:
 *         - key: name
 *           values:
 *             - sources:
 *                 - ${path:name.givenName}
 *         - key: last
 *           values:
 *             - sources:
 *                 - ${path:name.familyName}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Account Assignments using the `instance_arn`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/instanceAccessControlAttributes:InstanceAccessControlAttributes example arn:aws:sso:::instance/ssoins-0123456789abcdef
 * ```
 * @property attributes See AccessControlAttribute for more details.
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance.
 */
public data class InstanceAccessControlAttributesArgs(
    public val attributes: Output<List<InstanceAccessControlAttributesAttributeArgs>>? = null,
    public val instanceArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs =
        com.pulumi.aws.ssoadmin.InstanceAccessControlAttributesArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceAccessControlAttributesArgs].
 */
@PulumiTagMarker
public class InstanceAccessControlAttributesArgsBuilder internal constructor() {
    private var attributes: Output<List<InstanceAccessControlAttributesAttributeArgs>>? = null

    private var instanceArn: Output<String>? = null

    /**
     * @param value See AccessControlAttribute for more details.
     */
    @JvmName("krxtucdfggrehohj")
    public suspend fun attributes(`value`: Output<List<InstanceAccessControlAttributesAttributeArgs>>) {
        this.attributes = value
    }

    @JvmName("mjxxteyinsgtqkkh")
    public suspend fun attributes(vararg values: Output<InstanceAccessControlAttributesAttributeArgs>) {
        this.attributes = Output.all(values.asList())
    }

    /**
     * @param values See AccessControlAttribute for more details.
     */
    @JvmName("btlhnnfeswaepacy")
    public suspend fun attributes(values: List<Output<InstanceAccessControlAttributesAttributeArgs>>) {
        this.attributes = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance.
     */
    @JvmName("caiiqgjtsudoltae")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value See AccessControlAttribute for more details.
     */
    @JvmName("cougwunfpntjtkkh")
    public suspend fun attributes(`value`: List<InstanceAccessControlAttributesAttributeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument See AccessControlAttribute for more details.
     */
    @JvmName("dsobexvvlrrcnlre")
    public suspend fun attributes(argument: List<suspend InstanceAccessControlAttributesAttributeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InstanceAccessControlAttributesAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument See AccessControlAttribute for more details.
     */
    @JvmName("yqjhdscblhwcnkmj")
    public suspend fun attributes(vararg argument: suspend InstanceAccessControlAttributesAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InstanceAccessControlAttributesAttributeArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param argument See AccessControlAttribute for more details.
     */
    @JvmName("wwomwkpntkodqmxa")
    public suspend fun attributes(argument: suspend InstanceAccessControlAttributesAttributeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InstanceAccessControlAttributesAttributeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param values See AccessControlAttribute for more details.
     */
    @JvmName("dirdtkwdmpimbumh")
    public suspend fun attributes(vararg values: InstanceAccessControlAttributesAttributeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance.
     */
    @JvmName("irnnheoljkhprsbl")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    internal fun build(): InstanceAccessControlAttributesArgs = InstanceAccessControlAttributesArgs(
        attributes = attributes,
        instanceArn = instanceArn,
    )
}
