@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.PermissionSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Single Sign-On (SSO) Permission Set resource
 * > **NOTE:** Updating this resource will automatically [Provision the Permission Set](https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ProvisionPermissionSet.html) to apply the corresponding updates to all assigned accounts.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const examplePermissionSet = new aws.ssoadmin.PermissionSet("example", {
 *     name: "Example",
 *     description: "An example",
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     relayState: "https://s3.console.aws.amazon.com/s3/home?region=us-east-1#",
 *     sessionDuration: "PT2H",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_permission_set = aws.ssoadmin.PermissionSet("example",
 *     name="Example",
 *     description="An example",
 *     instance_arn=example.arns[0],
 *     relay_state="https://s3.console.aws.amazon.com/s3/home?region=us-east-1#",
 *     session_duration="PT2H")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var examplePermissionSet = new Aws.SsoAdmin.PermissionSet("example", new()
 *     {
 *         Name = "Example",
 *         Description = "An example",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         RelayState = "https://s3.console.aws.amazon.com/s3/home?region=us-east-1#",
 *         SessionDuration = "PT2H",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewPermissionSet(ctx, "example", &ssoadmin.PermissionSetArgs{
 * 			Name:            pulumi.String("Example"),
 * 			Description:     pulumi.String("An example"),
 * 			InstanceArn:     pulumi.String(example.Arns[0]),
 * 			RelayState:      pulumi.String("https://s3.console.aws.amazon.com/s3/home?region=us-east-1#"),
 * 			SessionDuration: pulumi.String("PT2H"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.PermissionSet;
 * import com.pulumi.aws.ssoadmin.PermissionSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var examplePermissionSet = new PermissionSet("examplePermissionSet", PermissionSetArgs.builder()
 *             .name("Example")
 *             .description("An example")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .relayState("https://s3.console.aws.amazon.com/s3/home?region=us-east-1#")
 *             .sessionDuration("PT2H")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   examplePermissionSet:
 *     type: aws:ssoadmin:PermissionSet
 *     name: example
 *     properties:
 *       name: Example
 *       description: An example
 *       instanceArn: ${example.arns[0]}
 *       relayState: https://s3.console.aws.amazon.com/s3/home?region=us-east-1#
 *       sessionDuration: PT2H
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Permission Sets using the `arn` and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/permissionSet:PermissionSet example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 * @property description The description of the Permission Set.
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
 * @property name The name of the Permission Set.
 * @property relayState The relay state URL used to redirect users within the application during the federation authentication process.
 * @property sessionDuration The length of time that the application user sessions are valid in the ISO-8601 standard. Default: `PT1H`.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class PermissionSetArgs(
    public val description: Output<String>? = null,
    public val instanceArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val relayState: Output<String>? = null,
    public val sessionDuration: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.PermissionSetArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.PermissionSetArgs =
        com.pulumi.aws.ssoadmin.PermissionSetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .relayState(relayState?.applyValue({ args0 -> args0 }))
            .sessionDuration(sessionDuration?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PermissionSetArgs].
 */
@PulumiTagMarker
public class PermissionSetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var instanceArn: Output<String>? = null

    private var name: Output<String>? = null

    private var relayState: Output<String>? = null

    private var sessionDuration: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of the Permission Set.
     */
    @JvmName("myvowpkshpmeenye")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("owxxdlwxtntwmrod")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The name of the Permission Set.
     */
    @JvmName("bcmtklmhevhggkiq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The relay state URL used to redirect users within the application during the federation authentication process.
     */
    @JvmName("weyhldnjxbdlbwne")
    public suspend fun relayState(`value`: Output<String>) {
        this.relayState = value
    }

    /**
     * @param value The length of time that the application user sessions are valid in the ISO-8601 standard. Default: `PT1H`.
     */
    @JvmName("nhmkcvrtxosapeqg")
    public suspend fun sessionDuration(`value`: Output<String>) {
        this.sessionDuration = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bpmrdnjqcxavpgqt")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of the Permission Set.
     */
    @JvmName("mjnnykibuiadebkr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("tnudjjwukxmdyhsk")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The name of the Permission Set.
     */
    @JvmName("wyvhmmjijbsubroo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The relay state URL used to redirect users within the application during the federation authentication process.
     */
    @JvmName("mdqvgtdpnunrjvhh")
    public suspend fun relayState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relayState = mapped
    }

    /**
     * @param value The length of time that the application user sessions are valid in the ISO-8601 standard. Default: `PT1H`.
     */
    @JvmName("knwfmmsutlqomlgo")
    public suspend fun sessionDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionDuration = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mrdgmdummphqourb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jktlhebjsilrayht")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PermissionSetArgs = PermissionSetArgs(
        description = description,
        instanceArn = instanceArn,
        name = name,
        relayState = relayState,
        sessionDuration = sessionDuration,
        tags = tags,
    )
}
