@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [PermissionSetInlinePolicy].
 */
@PulumiTagMarker
public class PermissionSetInlinePolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PermissionSetInlinePolicyArgs = PermissionSetInlinePolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PermissionSetInlinePolicyArgsBuilder.() -> Unit) {
        val builder = PermissionSetInlinePolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PermissionSetInlinePolicy {
        val builtJavaResource =
            com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PermissionSetInlinePolicy(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const examplePermissionSet = new aws.ssoadmin.PermissionSet("example", {
 *     name: "Example",
 *     instanceArn: example.then(example => example.arns?.[0]),
 * });
 * const exampleGetPolicyDocument = aws.iam.getPolicyDocument({
 *     statements: [{
 *         sid: "1",
 *         actions: [
 *             "s3:ListAllMyBuckets",
 *             "s3:GetBucketLocation",
 *         ],
 *         resources: ["arn:aws:s3:::*"],
 *     }],
 * });
 * const examplePermissionSetInlinePolicy = new aws.ssoadmin.PermissionSetInlinePolicy("example", {
 *     inlinePolicy: exampleGetPolicyDocument.then(exampleGetPolicyDocument => exampleGetPolicyDocument.json),
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     permissionSetArn: examplePermissionSet.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_permission_set = aws.ssoadmin.PermissionSet("example",
 *     name="Example",
 *     instance_arn=example.arns[0])
 * example_get_policy_document = aws.iam.get_policy_document(statements=[{
 *     "sid": "1",
 *     "actions": [
 *         "s3:ListAllMyBuckets",
 *         "s3:GetBucketLocation",
 *     ],
 *     "resources": ["arn:aws:s3:::*"],
 * }])
 * example_permission_set_inline_policy = aws.ssoadmin.PermissionSetInlinePolicy("example",
 *     inline_policy=example_get_policy_document.json,
 *     instance_arn=example.arns[0],
 *     permission_set_arn=example_permission_set.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var examplePermissionSet = new Aws.SsoAdmin.PermissionSet("example", new()
 *     {
 *         Name = "Example",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *     });
 *     var exampleGetPolicyDocument = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "1",
 *                 Actions = new[]
 *                 {
 *                     "s3:ListAllMyBuckets",
 *                     "s3:GetBucketLocation",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     "arn:aws:s3:::*",
 *                 },
 *             },
 *         },
 *     });
 *     var examplePermissionSetInlinePolicy = new Aws.SsoAdmin.PermissionSetInlinePolicy("example", new()
 *     {
 *         InlinePolicy = exampleGetPolicyDocument.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         PermissionSetArn = examplePermissionSet.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		examplePermissionSet, err := ssoadmin.NewPermissionSet(ctx, "example", &ssoadmin.PermissionSetArgs{
 * 			Name:        pulumi.String("Example"),
 * 			InstanceArn: pulumi.String(example.Arns[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleGetPolicyDocument, err := iam.GetPolicyDocument(ctx, &iam.GetPolicyDocumentArgs{
 * 			Statements: []iam.GetPolicyDocumentStatement{
 * 				{
 * 					Sid: pulumi.StringRef("1"),
 * 					Actions: []string{
 * 						"s3:ListAllMyBuckets",
 * 						"s3:GetBucketLocation",
 * 					},
 * 					Resources: []string{
 * 						"arn:aws:s3:::*",
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewPermissionSetInlinePolicy(ctx, "example", &ssoadmin.PermissionSetInlinePolicyArgs{
 * 			InlinePolicy:     pulumi.String(exampleGetPolicyDocument.Json),
 * 			InstanceArn:      pulumi.String(example.Arns[0]),
 * 			PermissionSetArn: examplePermissionSet.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.PermissionSet;
 * import com.pulumi.aws.ssoadmin.PermissionSetArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy;
 * import com.pulumi.aws.ssoadmin.PermissionSetInlinePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var examplePermissionSet = new PermissionSet("examplePermissionSet", PermissionSetArgs.builder()
 *             .name("Example")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .build());
 *         final var exampleGetPolicyDocument = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("1")
 *                 .actions(
 *                     "s3:ListAllMyBuckets",
 *                     "s3:GetBucketLocation")
 *                 .resources("arn:aws:s3:::*")
 *                 .build())
 *             .build());
 *         var examplePermissionSetInlinePolicy = new PermissionSetInlinePolicy("examplePermissionSetInlinePolicy", PermissionSetInlinePolicyArgs.builder()
 *             .inlinePolicy(exampleGetPolicyDocument.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json()))
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .permissionSetArn(examplePermissionSet.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   examplePermissionSet:
 *     type: aws:ssoadmin:PermissionSet
 *     name: example
 *     properties:
 *       name: Example
 *       instanceArn: ${example.arns[0]}
 *   examplePermissionSetInlinePolicy:
 *     type: aws:ssoadmin:PermissionSetInlinePolicy
 *     name: example
 *     properties:
 *       inlinePolicy: ${exampleGetPolicyDocument.json}
 *       instanceArn: ${example.arns[0]}
 *       permissionSetArn: ${examplePermissionSet.arn}
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 *   exampleGetPolicyDocument:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: '1'
 *             actions:
 *               - s3:ListAllMyBuckets
 *               - s3:GetBucketLocation
 *             resources:
 *               - arn:aws:s3:::*
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Permission Set Inline Policies using the `permission_set_arn` and `instance_arn` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/permissionSetInlinePolicy:PermissionSetInlinePolicy example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 */
public class PermissionSetInlinePolicy internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy,
) : KotlinCustomResource(javaResource, PermissionSetInlinePolicyMapper) {
    /**
     * The IAM inline policy to attach to a Permission Set.
     */
    public val inlinePolicy: Output<String>
        get() = javaResource.inlinePolicy().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Permission Set.
     */
    public val permissionSetArn: Output<String>
        get() = javaResource.permissionSetArn().applyValue({ args0 -> args0 })
}

public object PermissionSetInlinePolicyMapper : ResourceMapper<PermissionSetInlinePolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy::class == javaResource::class

    override fun map(javaResource: Resource): PermissionSetInlinePolicy =
        PermissionSetInlinePolicy(javaResource as com.pulumi.aws.ssoadmin.PermissionSetInlinePolicy)
}

/**
 * @see [PermissionSetInlinePolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PermissionSetInlinePolicy].
 */
public suspend fun permissionSetInlinePolicy(
    name: String,
    block: suspend PermissionSetInlinePolicyResourceBuilder.() -> Unit,
): PermissionSetInlinePolicy {
    val builder = PermissionSetInlinePolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PermissionSetInlinePolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun permissionSetInlinePolicy(name: String): PermissionSetInlinePolicy {
    val builder = PermissionSetInlinePolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
