@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs.builder
import com.pulumi.aws.ssoadmin.kotlin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Attaches a permissions boundary policy to a Single Sign-On (SSO) Permission Set resource.
 * > **NOTE:** A permission set can have at most one permissions boundary attached; using more than one `aws.ssoadmin.PermissionsBoundaryAttachment` references the same permission set will show a permanent difference.
 * ## Example Usage
 * ### Attaching a customer-managed policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const examplePermissionSet = new aws.ssoadmin.PermissionSet("example", {
 *     name: "Example",
 *     instanceArn: example.then(example => example.arns?.[0]),
 * });
 * const examplePolicy = new aws.iam.Policy("example", {
 *     name: "TestPolicy",
 *     description: "My test policy",
 *     policy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Action: ["ec2:Describe*"],
 *             Effect: "Allow",
 *             Resource: "*",
 *         }],
 *     }),
 * });
 * const examplePermissionsBoundaryAttachment = new aws.ssoadmin.PermissionsBoundaryAttachment("example", {
 *     instanceArn: examplePermissionSet.instanceArn,
 *     permissionSetArn: examplePermissionSet.arn,
 *     permissionsBoundary: {
 *         customerManagedPolicyReference: {
 *             name: examplePolicy.name,
 *             path: "/",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_permission_set = aws.ssoadmin.PermissionSet("example",
 *     name="Example",
 *     instance_arn=example.arns[0])
 * example_policy = aws.iam.Policy("example",
 *     name="TestPolicy",
 *     description="My test policy",
 *     policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Action": ["ec2:Describe*"],
 *             "Effect": "Allow",
 *             "Resource": "*",
 *         }],
 *     }))
 * example_permissions_boundary_attachment = aws.ssoadmin.PermissionsBoundaryAttachment("example",
 *     instance_arn=example_permission_set.instance_arn,
 *     permission_set_arn=example_permission_set.arn,
 *     permissions_boundary={
 *         "customer_managed_policy_reference": {
 *             "name": example_policy.name,
 *             "path": "/",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var examplePermissionSet = new Aws.SsoAdmin.PermissionSet("example", new()
 *     {
 *         Name = "Example",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *     });
 *     var examplePolicy = new Aws.Iam.Policy("example", new()
 *     {
 *         Name = "TestPolicy",
 *         Description = "My test policy",
 *         PolicyDocument = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = new[]
 *                     {
 *                         "ec2:Describe*",
 *                     },
 *                     ["Effect"] = "Allow",
 *                     ["Resource"] = "*",
 *                 },
 *             },
 *         }),
 *     });
 *     var examplePermissionsBoundaryAttachment = new Aws.SsoAdmin.PermissionsBoundaryAttachment("example", new()
 *     {
 *         InstanceArn = examplePermissionSet.InstanceArn,
 *         PermissionSetArn = examplePermissionSet.Arn,
 *         PermissionsBoundary = new Aws.SsoAdmin.Inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs
 *         {
 *             CustomerManagedPolicyReference = new Aws.SsoAdmin.Inputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs
 *             {
 *                 Name = examplePolicy.Name,
 *                 Path = "/",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		examplePermissionSet, err := ssoadmin.NewPermissionSet(ctx, "example", &ssoadmin.PermissionSetArgs{
 * 			Name:        pulumi.String("Example"),
 * 			InstanceArn: pulumi.String(example.Arns[0]),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": []string{
 * 						"ec2:Describe*",
 * 					},
 * 					"Effect":   "Allow",
 * 					"Resource": "*",
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		examplePolicy, err := iam.NewPolicy(ctx, "example", &iam.PolicyArgs{
 * 			Name:        pulumi.String("TestPolicy"),
 * 			Description: pulumi.String("My test policy"),
 * 			Policy:      pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewPermissionsBoundaryAttachment(ctx, "example", &ssoadmin.PermissionsBoundaryAttachmentArgs{
 * 			InstanceArn:      examplePermissionSet.InstanceArn,
 * 			PermissionSetArn: examplePermissionSet.Arn,
 * 			PermissionsBoundary: &ssoadmin.PermissionsBoundaryAttachmentPermissionsBoundaryArgs{
 * 				CustomerManagedPolicyReference: &ssoadmin.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs{
 * 					Name: examplePolicy.Name,
 * 					Path: pulumi.String("/"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.PermissionSet;
 * import com.pulumi.aws.ssoadmin.PermissionSetArgs;
 * import com.pulumi.aws.iam.Policy;
 * import com.pulumi.aws.iam.PolicyArgs;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs;
 * import com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs;
 * import com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var examplePermissionSet = new PermissionSet("examplePermissionSet", PermissionSetArgs.builder()
 *             .name("Example")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .build());
 *         var examplePolicy = new Policy("examplePolicy", PolicyArgs.builder()
 *             .name("TestPolicy")
 *             .description("My test policy")
 *             .policy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", jsonArray("ec2:Describe*")),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Resource", "*")
 *                     )))
 *                 )))
 *             .build());
 *         var examplePermissionsBoundaryAttachment = new PermissionsBoundaryAttachment("examplePermissionsBoundaryAttachment", PermissionsBoundaryAttachmentArgs.builder()
 *             .instanceArn(examplePermissionSet.instanceArn())
 *             .permissionSetArn(examplePermissionSet.arn())
 *             .permissionsBoundary(PermissionsBoundaryAttachmentPermissionsBoundaryArgs.builder()
 *                 .customerManagedPolicyReference(PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs.builder()
 *                     .name(examplePolicy.name())
 *                     .path("/")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   examplePermissionSet:
 *     type: aws:ssoadmin:PermissionSet
 *     name: example
 *     properties:
 *       name: Example
 *       instanceArn: ${example.arns[0]}
 *   examplePolicy:
 *     type: aws:iam:Policy
 *     name: example
 *     properties:
 *       name: TestPolicy
 *       description: My test policy
 *       policy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Action:
 *                 - ec2:Describe*
 *               Effect: Allow
 *               Resource: '*'
 *   examplePermissionsBoundaryAttachment:
 *     type: aws:ssoadmin:PermissionsBoundaryAttachment
 *     name: example
 *     properties:
 *       instanceArn: ${examplePermissionSet.instanceArn}
 *       permissionSetArn: ${examplePermissionSet.arn}
 *       permissionsBoundary:
 *         customerManagedPolicyReference:
 *           name: ${examplePolicy.name}
 *           path: /
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Attaching an AWS-managed policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.ssoadmin.PermissionsBoundaryAttachment("example", {
 *     instanceArn: exampleAwsSsoadminPermissionSet.instanceArn,
 *     permissionSetArn: exampleAwsSsoadminPermissionSet.arn,
 *     permissionsBoundary: {
 *         managedPolicyArn: "arn:aws:iam::aws:policy/ReadOnlyAccess",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.PermissionsBoundaryAttachment("example",
 *     instance_arn=example_aws_ssoadmin_permission_set["instanceArn"],
 *     permission_set_arn=example_aws_ssoadmin_permission_set["arn"],
 *     permissions_boundary={
 *         "managed_policy_arn": "arn:aws:iam::aws:policy/ReadOnlyAccess",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.SsoAdmin.PermissionsBoundaryAttachment("example", new()
 *     {
 *         InstanceArn = exampleAwsSsoadminPermissionSet.InstanceArn,
 *         PermissionSetArn = exampleAwsSsoadminPermissionSet.Arn,
 *         PermissionsBoundary = new Aws.SsoAdmin.Inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs
 *         {
 *             ManagedPolicyArn = "arn:aws:iam::aws:policy/ReadOnlyAccess",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := ssoadmin.NewPermissionsBoundaryAttachment(ctx, "example", &ssoadmin.PermissionsBoundaryAttachmentArgs{
 * 			InstanceArn:      pulumi.Any(exampleAwsSsoadminPermissionSet.InstanceArn),
 * 			PermissionSetArn: pulumi.Any(exampleAwsSsoadminPermissionSet.Arn),
 * 			PermissionsBoundary: &ssoadmin.PermissionsBoundaryAttachmentPermissionsBoundaryArgs{
 * 				ManagedPolicyArn: pulumi.String("arn:aws:iam::aws:policy/ReadOnlyAccess"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachment;
 * import com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs;
 * import com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new PermissionsBoundaryAttachment("example", PermissionsBoundaryAttachmentArgs.builder()
 *             .instanceArn(exampleAwsSsoadminPermissionSet.instanceArn())
 *             .permissionSetArn(exampleAwsSsoadminPermissionSet.arn())
 *             .permissionsBoundary(PermissionsBoundaryAttachmentPermissionsBoundaryArgs.builder()
 *                 .managedPolicyArn("arn:aws:iam::aws:policy/ReadOnlyAccess")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:ssoadmin:PermissionsBoundaryAttachment
 *     properties:
 *       instanceArn: ${exampleAwsSsoadminPermissionSet.instanceArn}
 *       permissionSetArn: ${exampleAwsSsoadminPermissionSet.arn}
 *       permissionsBoundary:
 *         managedPolicyArn: arn:aws:iam::aws:policy/ReadOnlyAccess
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Permissions Boundary Attachments using the `permission_set_arn` and `instance_arn`, separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/permissionsBoundaryAttachment:PermissionsBoundaryAttachment example arn:aws:sso:::permissionSet/ssoins-2938j0x8920sbj72/ps-80383020jr9302rk,arn:aws:sso:::instance/ssoins-2938j0x8920sbj72
 * ```
 * @property instanceArn The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
 * @property permissionSetArn The Amazon Resource Name (ARN) of the Permission Set.
 * @property permissionsBoundary The permissions boundary policy. See below.
 */
public data class PermissionsBoundaryAttachmentArgs(
    public val instanceArn: Output<String>? = null,
    public val permissionSetArn: Output<String>? = null,
    public val permissionsBoundary: Output<PermissionsBoundaryAttachmentPermissionsBoundaryArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs =
        com.pulumi.aws.ssoadmin.PermissionsBoundaryAttachmentArgs.builder()
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .permissionSetArn(permissionSetArn?.applyValue({ args0 -> args0 }))
            .permissionsBoundary(
                permissionsBoundary?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PermissionsBoundaryAttachmentArgs].
 */
@PulumiTagMarker
public class PermissionsBoundaryAttachmentArgsBuilder internal constructor() {
    private var instanceArn: Output<String>? = null

    private var permissionSetArn: Output<String>? = null

    private var permissionsBoundary: Output<PermissionsBoundaryAttachmentPermissionsBoundaryArgs>? =
        null

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("nqrnwvkvrcscsymb")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("arljvhglqgcerduh")
    public suspend fun permissionSetArn(`value`: Output<String>) {
        this.permissionSetArn = value
    }

    /**
     * @param value The permissions boundary policy. See below.
     */
    @JvmName("cbilerqqsnsbyffi")
    public suspend fun permissionsBoundary(`value`: Output<PermissionsBoundaryAttachmentPermissionsBoundaryArgs>) {
        this.permissionsBoundary = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the SSO Instance under which the operation will be executed.
     */
    @JvmName("kabwnojqkgtnnyip")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Permission Set.
     */
    @JvmName("vdfeibdsfipejfln")
    public suspend fun permissionSetArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionSetArn = mapped
    }

    /**
     * @param value The permissions boundary policy. See below.
     */
    @JvmName("qhsxjrhxryktnbvu")
    public suspend fun permissionsBoundary(`value`: PermissionsBoundaryAttachmentPermissionsBoundaryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionsBoundary = mapped
    }

    /**
     * @param argument The permissions boundary policy. See below.
     */
    @JvmName("gouhwgodxrwgvcmg")
    public suspend fun permissionsBoundary(argument: suspend PermissionsBoundaryAttachmentPermissionsBoundaryArgsBuilder.() -> Unit) {
        val toBeMapped = PermissionsBoundaryAttachmentPermissionsBoundaryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.permissionsBoundary = mapped
    }

    internal fun build(): PermissionsBoundaryAttachmentArgs = PermissionsBoundaryAttachmentArgs(
        instanceArn = instanceArn,
        permissionSetArn = permissionSetArn,
        permissionsBoundary = permissionsBoundary,
    )
}
