@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.SsoadminFunctions.getApplicationAssignmentsPlain
import com.pulumi.aws.ssoadmin.SsoadminFunctions.getApplicationPlain
import com.pulumi.aws.ssoadmin.SsoadminFunctions.getApplicationProvidersPlain
import com.pulumi.aws.ssoadmin.SsoadminFunctions.getInstancesPlain
import com.pulumi.aws.ssoadmin.SsoadminFunctions.getPermissionSetPlain
import com.pulumi.aws.ssoadmin.SsoadminFunctions.getPrincipalApplicationAssignmentsPlain
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationAssignmentsApplicationAssignment
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationAssignmentsPlainArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationAssignmentsPlainArgsBuilder
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationPlainArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationPlainArgsBuilder
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationPortalOption
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationProvidersApplicationProvider
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationProvidersPlainArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetApplicationProvidersPlainArgsBuilder
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetPermissionSetPlainArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetPermissionSetPlainArgsBuilder
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetPrincipalApplicationAssignmentsApplicationAssignment
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetPrincipalApplicationAssignmentsPlainArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.GetPrincipalApplicationAssignmentsPlainArgsBuilder
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationAssignmentsResult
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationProvidersResult
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationResult
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetInstancesResult
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetPermissionSetResult
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetPrincipalApplicationAssignmentsResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationAssignmentsResult.Companion.toKotlin as getApplicationAssignmentsResultToKotlin
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationProvidersResult.Companion.toKotlin as getApplicationProvidersResultToKotlin
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationResult.Companion.toKotlin as getApplicationResultToKotlin
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetInstancesResult.Companion.toKotlin as getInstancesResultToKotlin
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetPermissionSetResult.Companion.toKotlin as getPermissionSetResultToKotlin
import com.pulumi.aws.ssoadmin.kotlin.outputs.GetPrincipalApplicationAssignmentsResult.Companion.toKotlin as getPrincipalApplicationAssignmentsResultToKotlin

public object SsoadminFunctions {
    /**
     * Data source for managing an AWS SSO Admin Application.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getApplication({
     *     applicationArn: "arn:aws:sso::012345678901:application/ssoins-1234/apl-5678",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_application(application_arn="arn:aws:sso::012345678901:application/ssoins-1234/apl-5678")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetApplication.Invoke(new()
     *     {
     *         ApplicationArn = "arn:aws:sso::012345678901:application/ssoins-1234/apl-5678",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssoadmin.LookupApplication(ctx, &ssoadmin.LookupApplicationArgs{
     * 			ApplicationArn: "arn:aws:sso::012345678901:application/ssoins-1234/apl-5678",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.ssoadmin.inputs.GetApplicationArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getApplication(GetApplicationArgs.builder()
     *             .applicationArn("arn:aws:sso::012345678901:application/ssoins-1234/apl-5678")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getApplication
     *       Arguments:
     *         applicationArn: arn:aws:sso::012345678901:application/ssoins-1234/apl-5678
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplication.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: GetApplicationPlainArgs): GetApplicationResult =
        getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())

    /**
     * @see [getApplication].
     * @param applicationArn ARN of the application.
     * @param portalOptions Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(
        applicationArn: String,
        portalOptions: List<GetApplicationPortalOption>? = null,
    ): GetApplicationResult {
        val argument = GetApplicationPlainArgs(
            applicationArn = applicationArn,
            portalOptions = portalOptions,
        )
        return getApplicationResultToKotlin(getApplicationPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplication].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssoadmin&#46;kotlin&#46;inputs&#46;GetApplicationPlainArgs].
     * @return A collection of values returned by getApplication.
     */
    public suspend fun getApplication(argument: suspend GetApplicationPlainArgsBuilder.() -> Unit): GetApplicationResult {
        val builder = GetApplicationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationResultToKotlin(getApplicationPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS SSO Admin Application Assignments.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getApplicationAssignments({
     *     applicationArn: exampleAwsSsoadminApplication.applicationArn,
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_application_assignments(application_arn=example_aws_ssoadmin_application["applicationArn"])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetApplicationAssignments.Invoke(new()
     *     {
     *         ApplicationArn = exampleAwsSsoadminApplication.ApplicationArn,
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssoadmin.GetApplicationAssignments(ctx, &ssoadmin.GetApplicationAssignmentsArgs{
     * 			ApplicationArn: exampleAwsSsoadminApplication.ApplicationArn,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getApplicationAssignments(GetApplicationAssignmentsArgs.builder()
     *             .applicationArn(exampleAwsSsoadminApplication.applicationArn())
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getApplicationAssignments
     *       Arguments:
     *         applicationArn: ${exampleAwsSsoadminApplication.applicationArn}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplicationAssignments.
     * @return A collection of values returned by getApplicationAssignments.
     */
    public suspend fun getApplicationAssignments(argument: GetApplicationAssignmentsPlainArgs): GetApplicationAssignmentsResult =
        getApplicationAssignmentsResultToKotlin(getApplicationAssignmentsPlain(argument.toJava()).await())

    /**
     * @see [getApplicationAssignments].
     * @param applicationArn ARN of the application.
     * @param applicationAssignments List of principals assigned to the application. See the `application_assignments` attribute reference below.
     * @return A collection of values returned by getApplicationAssignments.
     */
    public suspend fun getApplicationAssignments(
        applicationArn: String,
        applicationAssignments: List<GetApplicationAssignmentsApplicationAssignment>? = null,
    ): GetApplicationAssignmentsResult {
        val argument = GetApplicationAssignmentsPlainArgs(
            applicationArn = applicationArn,
            applicationAssignments = applicationAssignments,
        )
        return getApplicationAssignmentsResultToKotlin(getApplicationAssignmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationAssignments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssoadmin&#46;kotlin&#46;inputs&#46;GetApplicationAssignmentsPlainArgs].
     * @return A collection of values returned by getApplicationAssignments.
     */
    public suspend fun getApplicationAssignments(argument: suspend GetApplicationAssignmentsPlainArgsBuilder.() -> Unit): GetApplicationAssignmentsResult {
        val builder = GetApplicationAssignmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationAssignmentsResultToKotlin(getApplicationAssignmentsPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing AWS SSO Admin Application Providers.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getApplicationProviders({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_application_providers()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetApplicationProviders.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssoadmin.GetApplicationProviders(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getApplicationProviders();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getApplicationProviders
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getApplicationProviders.
     * @return A collection of values returned by getApplicationProviders.
     */
    public suspend fun getApplicationProviders(argument: GetApplicationProvidersPlainArgs): GetApplicationProvidersResult =
        getApplicationProvidersResultToKotlin(getApplicationProvidersPlain(argument.toJava()).await())

    /**
     * @see [getApplicationProviders].
     * @param applicationProviders A list of application providers available in the current region. See `application_providers` below.
     * @return A collection of values returned by getApplicationProviders.
     */
    public suspend fun getApplicationProviders(
        applicationProviders: List<GetApplicationProvidersApplicationProvider>? =
            null,
    ): GetApplicationProvidersResult {
        val argument = GetApplicationProvidersPlainArgs(
            applicationProviders = applicationProviders,
        )
        return getApplicationProvidersResultToKotlin(getApplicationProvidersPlain(argument.toJava()).await())
    }

    /**
     * @see [getApplicationProviders].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssoadmin&#46;kotlin&#46;inputs&#46;GetApplicationProvidersPlainArgs].
     * @return A collection of values returned by getApplicationProviders.
     */
    public suspend fun getApplicationProviders(argument: suspend GetApplicationProvidersPlainArgsBuilder.() -> Unit): GetApplicationProvidersResult {
        val builder = GetApplicationProvidersPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getApplicationProvidersResultToKotlin(getApplicationProvidersPlain(builtArgument.toJava()).await())
    }

    /**
     * Use this data source to get ARNs and Identity Store IDs of Single Sign-On (SSO) Instances.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getInstances({});
     * export const arn = example.then(example => example.arns?.[0]);
     * export const identityStoreId = example.then(example => example.identityStoreIds?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_instances()
     * pulumi.export("arn", example.arns[0])
     * pulumi.export("identityStoreId", example.identity_store_ids[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetInstances.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["arn"] = example&#46;Apply(getInstancesResult => getInstancesResult&#46;Arns[0]),
     *         ["identityStoreId"] = example&#46;Apply(getInstancesResult => getInstancesResult&#46;IdentityStoreIds[0]),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("arn", example.Arns[0])
     * 		ctx.Export("identityStoreId", example.IdentityStoreIds[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getInstances();
     *         ctx.export("arn", example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]));
     *         ctx.export("identityStoreId", example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getInstances
     *       Arguments: {}
     * outputs:
     *   arn: ${example.arns[0]}
     *   identityStoreId: ${example.identityStoreIds[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument Use this data source to get ARNs and Identity Store IDs of Single Sign-On (SSO) Instances.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getInstances({});
     * export const arn = example.then(example => example.arns?.[0]);
     * export const identityStoreId = example.then(example => example.identityStoreIds?.[0]);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_instances()
     * pulumi.export("arn", example.arns[0])
     * pulumi.export("identityStoreId", example.identity_store_ids[0])
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetInstances.Invoke();
     *     return new Dictionary<string, object?>
     *     {
     *         ["arn"] = example&#46;Apply(getInstancesResult => getInstancesResult&#46;Arns[0]),
     *         ["identityStoreId"] = example&#46;Apply(getInstancesResult => getInstancesResult&#46;IdentityStoreIds[0]),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("arn", example.Arns[0])
     * 		ctx.Export("identityStoreId", example.IdentityStoreIds[0])
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getInstances();
     *         ctx.export("arn", example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]));
     *         ctx.export("identityStoreId", example.applyValue(getInstancesResult -> getInstancesResult.identityStoreIds()[0]));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getInstances
     *       Arguments: {}
     * outputs:
     *   arn: ${example.arns[0]}
     *   identityStoreId: ${example.identityStoreIds[0]}
     * ```
     * <!--End PulumiCodeChooser -->
     * @return A collection of values returned by getInstances.
     */
    public suspend fun getInstances(): GetInstancesResult =
        getInstancesResultToKotlin(getInstancesPlain().await())

    /**
     * Use this data source to get a Single Sign-On (SSO) Permission Set.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getInstances({});
     * const exampleGetPermissionSet = example.then(example => aws.ssoadmin.getPermissionSet({
     *     instanceArn: example.arns?.[0],
     *     name: "Example",
     * }));
     * export const arn = exampleGetPermissionSet.then(exampleGetPermissionSet => exampleGetPermissionSet.arn);
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_instances()
     * example_get_permission_set = aws.ssoadmin.get_permission_set(instance_arn=example.arns[0],
     *     name="Example")
     * pulumi.export("arn", example_get_permission_set.arn)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetInstances.Invoke();
     *     var exampleGetPermissionSet = Aws.SsoAdmin.GetPermissionSet.Invoke(new()
     *     {
     *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
     *         Name = "Example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["arn"] = exampleGetPermissionSet.Apply(getPermissionSetResult => getPermissionSetResult.Arn),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		exampleGetPermissionSet, err := ssoadmin.LookupPermissionSet(ctx, &ssoadmin.LookupPermissionSetArgs{
     * 			InstanceArn: example.Arns[0],
     * 			Name:        pulumi.StringRef("Example"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("arn", exampleGetPermissionSet.Arn)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.ssoadmin.inputs.GetPermissionSetArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getInstances();
     *         final var exampleGetPermissionSet = SsoadminFunctions.getPermissionSet(GetPermissionSetArgs.builder()
     *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
     *             .name("Example")
     *             .build());
     *         ctx.export("arn", exampleGetPermissionSet.applyValue(getPermissionSetResult -> getPermissionSetResult.arn()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getInstances
     *       Arguments: {}
     *   exampleGetPermissionSet:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getPermissionSet
     *       Arguments:
     *         instanceArn: ${example.arns[0]}
     *         name: Example
     * outputs:
     *   arn: ${exampleGetPermissionSet.arn}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPermissionSet.
     * @return A collection of values returned by getPermissionSet.
     */
    public suspend fun getPermissionSet(argument: GetPermissionSetPlainArgs): GetPermissionSetResult =
        getPermissionSetResultToKotlin(getPermissionSetPlain(argument.toJava()).await())

    /**
     * @see [getPermissionSet].
     * @param arn ARN of the permission set.
     * @param instanceArn ARN of the SSO Instance associated with the permission set.
     * @param name Name of the SSO Permission Set.
     * @param tags Key-value map of resource tags.
     * @return A collection of values returned by getPermissionSet.
     */
    public suspend fun getPermissionSet(
        arn: String? = null,
        instanceArn: String,
        name: String? = null,
        tags: Map<String, String>? = null,
    ): GetPermissionSetResult {
        val argument = GetPermissionSetPlainArgs(
            arn = arn,
            instanceArn = instanceArn,
            name = name,
            tags = tags,
        )
        return getPermissionSetResultToKotlin(getPermissionSetPlain(argument.toJava()).await())
    }

    /**
     * @see [getPermissionSet].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssoadmin&#46;kotlin&#46;inputs&#46;GetPermissionSetPlainArgs].
     * @return A collection of values returned by getPermissionSet.
     */
    public suspend fun getPermissionSet(argument: suspend GetPermissionSetPlainArgsBuilder.() -> Unit): GetPermissionSetResult {
        val builder = GetPermissionSetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPermissionSetResultToKotlin(getPermissionSetPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for viewing AWS SSO Admin Principal Application Assignments.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.ssoadmin.getPrincipalApplicationAssignments({
     *     instanceArn: test.arns[0],
     *     principalId: testAwsIdentitystoreUser.userId,
     *     principalType: "USER",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.ssoadmin.get_principal_application_assignments(instance_arn=test["arns"],
     *     principal_id=test_aws_identitystore_user["userId"],
     *     principal_type="USER")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.SsoAdmin.GetPrincipalApplicationAssignments.Invoke(new()
     *     {
     *         InstanceArn = test.Arns[0],
     *         PrincipalId = testAwsIdentitystoreUser.UserId,
     *         PrincipalType = "USER",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := ssoadmin.GetPrincipalApplicationAssignments(ctx, &ssoadmin.GetPrincipalApplicationAssignmentsArgs{
     * 			InstanceArn:   test.Arns[0],
     * 			PrincipalId:   testAwsIdentitystoreUser.UserId,
     * 			PrincipalType: "USER",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
     * import com.pulumi.aws.ssoadmin.inputs.GetPrincipalApplicationAssignmentsArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = SsoadminFunctions.getPrincipalApplicationAssignments(GetPrincipalApplicationAssignmentsArgs.builder()
     *             .instanceArn(test.arns()[0])
     *             .principalId(testAwsIdentitystoreUser.userId())
     *             .principalType("USER")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:ssoadmin:getPrincipalApplicationAssignments
     *       Arguments:
     *         instanceArn: ${test.arns[0]}
     *         principalId: ${testAwsIdentitystoreUser.userId}
     *         principalType: USER
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getPrincipalApplicationAssignments.
     * @return A collection of values returned by getPrincipalApplicationAssignments.
     */
    public suspend fun getPrincipalApplicationAssignments(argument: GetPrincipalApplicationAssignmentsPlainArgs): GetPrincipalApplicationAssignmentsResult =
        getPrincipalApplicationAssignmentsResultToKotlin(getPrincipalApplicationAssignmentsPlain(argument.toJava()).await())

    /**
     * @see [getPrincipalApplicationAssignments].
     * @param applicationAssignments List of principals assigned to the application. See the `application_assignments` attribute reference below.
     * @param instanceArn ARN of the instance of IAM Identity Center.
     * @param principalId An identifier for an object in IAM Identity Center, such as a user or group.
     * @param principalType Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
     * @return A collection of values returned by getPrincipalApplicationAssignments.
     */
    public suspend fun getPrincipalApplicationAssignments(
        applicationAssignments: List<GetPrincipalApplicationAssignmentsApplicationAssignment>? = null,
        instanceArn: String,
        principalId: String,
        principalType: String,
    ): GetPrincipalApplicationAssignmentsResult {
        val argument = GetPrincipalApplicationAssignmentsPlainArgs(
            applicationAssignments = applicationAssignments,
            instanceArn = instanceArn,
            principalId = principalId,
            principalType = principalType,
        )
        return getPrincipalApplicationAssignmentsResultToKotlin(getPrincipalApplicationAssignmentsPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrincipalApplicationAssignments].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;ssoadmin&#46;kotlin&#46;inputs&#46;GetPrincipalApplicationAssignmentsPlainArgs].
     * @return A collection of values returned by getPrincipalApplicationAssignments.
     */
    public suspend fun getPrincipalApplicationAssignments(argument: suspend GetPrincipalApplicationAssignmentsPlainArgsBuilder.() -> Unit): GetPrincipalApplicationAssignmentsResult {
        val builder = GetPrincipalApplicationAssignmentsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrincipalApplicationAssignmentsResultToKotlin(getPrincipalApplicationAssignmentsPlain(builtArgument.toJava()).await())
    }
}
