@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.kotlin.outputs.TrustedTokenIssuerTrustedTokenIssuerConfiguration
import com.pulumi.aws.ssoadmin.kotlin.outputs.TrustedTokenIssuerTrustedTokenIssuerConfiguration.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TrustedTokenIssuer].
 */
@PulumiTagMarker
public class TrustedTokenIssuerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TrustedTokenIssuerArgs = TrustedTokenIssuerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TrustedTokenIssuerArgsBuilder.() -> Unit) {
        val builder = TrustedTokenIssuerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TrustedTokenIssuer {
        val builtJavaResource = com.pulumi.aws.ssoadmin.TrustedTokenIssuer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TrustedTokenIssuer(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS SSO Admin Trusted Token Issuer.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleTrustedTokenIssuer = new aws.ssoadmin.TrustedTokenIssuer("example", {
 *     name: "example",
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     trustedTokenIssuerType: "OIDC_JWT",
 *     trustedTokenIssuerConfiguration: {
 *         oidcJwtConfiguration: {
 *             claimAttributePath: "email",
 *             identityStoreAttributePath: "emails.value",
 *             issuerUrl: "https://example.com",
 *             jwksRetrievalOption: "OPEN_ID_DISCOVERY",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_trusted_token_issuer = aws.ssoadmin.TrustedTokenIssuer("example",
 *     name="example",
 *     instance_arn=example.arns[0],
 *     trusted_token_issuer_type="OIDC_JWT",
 *     trusted_token_issuer_configuration={
 *         "oidc_jwt_configuration": {
 *             "claim_attribute_path": "email",
 *             "identity_store_attribute_path": "emails.value",
 *             "issuer_url": "https://example.com",
 *             "jwks_retrieval_option": "OPEN_ID_DISCOVERY",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleTrustedTokenIssuer = new Aws.SsoAdmin.TrustedTokenIssuer("example", new()
 *     {
 *         Name = "example",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         TrustedTokenIssuerType = "OIDC_JWT",
 *         TrustedTokenIssuerConfiguration = new Aws.SsoAdmin.Inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs
 *         {
 *             OidcJwtConfiguration = new Aws.SsoAdmin.Inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs
 *             {
 *                 ClaimAttributePath = "email",
 *                 IdentityStoreAttributePath = "emails.value",
 *                 IssuerUrl = "https://example.com",
 *                 JwksRetrievalOption = "OPEN_ID_DISCOVERY",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewTrustedTokenIssuer(ctx, "example", &ssoadmin.TrustedTokenIssuerArgs{
 * 			Name:                   pulumi.String("example"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 			TrustedTokenIssuerType: pulumi.String("OIDC_JWT"),
 * 			TrustedTokenIssuerConfiguration: &ssoadmin.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs{
 * 				OidcJwtConfiguration: &ssoadmin.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs{
 * 					ClaimAttributePath:         pulumi.String("email"),
 * 					IdentityStoreAttributePath: pulumi.String("emails.value"),
 * 					IssuerUrl:                  pulumi.String("https://example.com"),
 * 					JwksRetrievalOption:        pulumi.String("OPEN_ID_DISCOVERY"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.TrustedTokenIssuer;
 * import com.pulumi.aws.ssoadmin.TrustedTokenIssuerArgs;
 * import com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs;
 * import com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleTrustedTokenIssuer = new TrustedTokenIssuer("exampleTrustedTokenIssuer", TrustedTokenIssuerArgs.builder()
 *             .name("example")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .trustedTokenIssuerType("OIDC_JWT")
 *             .trustedTokenIssuerConfiguration(TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs.builder()
 *                 .oidcJwtConfiguration(TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs.builder()
 *                     .claimAttributePath("email")
 *                     .identityStoreAttributePath("emails.value")
 *                     .issuerUrl("https://example.com")
 *                     .jwksRetrievalOption("OPEN_ID_DISCOVERY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleTrustedTokenIssuer:
 *     type: aws:ssoadmin:TrustedTokenIssuer
 *     name: example
 *     properties:
 *       name: example
 *       instanceArn: ${example.arns[0]}
 *       trustedTokenIssuerType: OIDC_JWT
 *       trustedTokenIssuerConfiguration:
 *         oidcJwtConfiguration:
 *           claimAttributePath: email
 *           identityStoreAttributePath: emails.value
 *           issuerUrl: https://example.com
 *           jwksRetrievalOption: OPEN_ID_DISCOVERY
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Trusted Token Issuer using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/trustedTokenIssuer:TrustedTokenIssuer example arn:aws:sso::012345678901:trustedTokenIssuer/ssoins-lu1ye3gew4mbc7ju/tti-2657c556-9707-11ee-b9d1-0242ac120002
 * ```
 */
public class TrustedTokenIssuer internal constructor(
    override val javaResource: com.pulumi.aws.ssoadmin.TrustedTokenIssuer,
) : KotlinCustomResource(javaResource, TrustedTokenIssuerMapper) {
    /**
     * ARN of the trusted token issuer.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
     */
    public val clientToken: Output<String>?
        get() = javaResource.clientToken().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the instance of IAM Identity Center.
     */
    public val instanceArn: Output<String>
        get() = javaResource.instanceArn().applyValue({ args0 -> args0 })

    /**
     * Name of the trusted token issuer.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
     */
    public val trustedTokenIssuerConfiguration:
        Output<TrustedTokenIssuerTrustedTokenIssuerConfiguration>?
        get() = javaResource.trustedTokenIssuerConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
     * The following arguments are optional:
     */
    public val trustedTokenIssuerType: Output<String>
        get() = javaResource.trustedTokenIssuerType().applyValue({ args0 -> args0 })
}

public object TrustedTokenIssuerMapper : ResourceMapper<TrustedTokenIssuer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.ssoadmin.TrustedTokenIssuer::class == javaResource::class

    override fun map(javaResource: Resource): TrustedTokenIssuer = TrustedTokenIssuer(
        javaResource as
            com.pulumi.aws.ssoadmin.TrustedTokenIssuer,
    )
}

/**
 * @see [TrustedTokenIssuer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TrustedTokenIssuer].
 */
public suspend fun trustedTokenIssuer(
    name: String,
    block: suspend TrustedTokenIssuerResourceBuilder.() -> Unit,
): TrustedTokenIssuer {
    val builder = TrustedTokenIssuerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TrustedTokenIssuer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun trustedTokenIssuer(name: String): TrustedTokenIssuer {
    val builder = TrustedTokenIssuerResourceBuilder()
    builder.name(name)
    return builder.build()
}
