@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin

import com.pulumi.aws.ssoadmin.TrustedTokenIssuerArgs.builder
import com.pulumi.aws.ssoadmin.kotlin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs
import com.pulumi.aws.ssoadmin.kotlin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS SSO Admin Trusted Token Issuer.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = aws.ssoadmin.getInstances({});
 * const exampleTrustedTokenIssuer = new aws.ssoadmin.TrustedTokenIssuer("example", {
 *     name: "example",
 *     instanceArn: example.then(example => example.arns?.[0]),
 *     trustedTokenIssuerType: "OIDC_JWT",
 *     trustedTokenIssuerConfiguration: {
 *         oidcJwtConfiguration: {
 *             claimAttributePath: "email",
 *             identityStoreAttributePath: "emails.value",
 *             issuerUrl: "https://example.com",
 *             jwksRetrievalOption: "OPEN_ID_DISCOVERY",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.ssoadmin.get_instances()
 * example_trusted_token_issuer = aws.ssoadmin.TrustedTokenIssuer("example",
 *     name="example",
 *     instance_arn=example.arns[0],
 *     trusted_token_issuer_type="OIDC_JWT",
 *     trusted_token_issuer_configuration={
 *         "oidc_jwt_configuration": {
 *             "claim_attribute_path": "email",
 *             "identity_store_attribute_path": "emails.value",
 *             "issuer_url": "https://example.com",
 *             "jwks_retrieval_option": "OPEN_ID_DISCOVERY",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = Aws.SsoAdmin.GetInstances.Invoke();
 *     var exampleTrustedTokenIssuer = new Aws.SsoAdmin.TrustedTokenIssuer("example", new()
 *     {
 *         Name = "example",
 *         InstanceArn = example.Apply(getInstancesResult => getInstancesResult.Arns[0]),
 *         TrustedTokenIssuerType = "OIDC_JWT",
 *         TrustedTokenIssuerConfiguration = new Aws.SsoAdmin.Inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs
 *         {
 *             OidcJwtConfiguration = new Aws.SsoAdmin.Inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs
 *             {
 *                 ClaimAttributePath = "email",
 *                 IdentityStoreAttributePath = "emails.value",
 *                 IssuerUrl = "https://example.com",
 *                 JwksRetrievalOption = "OPEN_ID_DISCOVERY",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/ssoadmin"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := ssoadmin.GetInstances(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = ssoadmin.NewTrustedTokenIssuer(ctx, "example", &ssoadmin.TrustedTokenIssuerArgs{
 * 			Name:                   pulumi.String("example"),
 * 			InstanceArn:            pulumi.String(example.Arns[0]),
 * 			TrustedTokenIssuerType: pulumi.String("OIDC_JWT"),
 * 			TrustedTokenIssuerConfiguration: &ssoadmin.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs{
 * 				OidcJwtConfiguration: &ssoadmin.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs{
 * 					ClaimAttributePath:         pulumi.String("email"),
 * 					IdentityStoreAttributePath: pulumi.String("emails.value"),
 * 					IssuerUrl:                  pulumi.String("https://example.com"),
 * 					JwksRetrievalOption:        pulumi.String("OPEN_ID_DISCOVERY"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.ssoadmin.SsoadminFunctions;
 * import com.pulumi.aws.ssoadmin.TrustedTokenIssuer;
 * import com.pulumi.aws.ssoadmin.TrustedTokenIssuerArgs;
 * import com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs;
 * import com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var example = SsoadminFunctions.getInstances();
 *         var exampleTrustedTokenIssuer = new TrustedTokenIssuer("exampleTrustedTokenIssuer", TrustedTokenIssuerArgs.builder()
 *             .name("example")
 *             .instanceArn(example.applyValue(getInstancesResult -> getInstancesResult.arns()[0]))
 *             .trustedTokenIssuerType("OIDC_JWT")
 *             .trustedTokenIssuerConfiguration(TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs.builder()
 *                 .oidcJwtConfiguration(TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs.builder()
 *                     .claimAttributePath("email")
 *                     .identityStoreAttributePath("emails.value")
 *                     .issuerUrl("https://example.com")
 *                     .jwksRetrievalOption("OPEN_ID_DISCOVERY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   exampleTrustedTokenIssuer:
 *     type: aws:ssoadmin:TrustedTokenIssuer
 *     name: example
 *     properties:
 *       name: example
 *       instanceArn: ${example.arns[0]}
 *       trustedTokenIssuerType: OIDC_JWT
 *       trustedTokenIssuerConfiguration:
 *         oidcJwtConfiguration:
 *           claimAttributePath: email
 *           identityStoreAttributePath: emails.value
 *           issuerUrl: https://example.com
 *           jwksRetrievalOption: OPEN_ID_DISCOVERY
 * variables:
 *   example:
 *     fn::invoke:
 *       Function: aws:ssoadmin:getInstances
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import SSO Admin Trusted Token Issuer using the `id`. For example:
 * ```sh
 * $ pulumi import aws:ssoadmin/trustedTokenIssuer:TrustedTokenIssuer example arn:aws:sso::012345678901:trustedTokenIssuer/ssoins-lu1ye3gew4mbc7ju/tti-2657c556-9707-11ee-b9d1-0242ac120002
 * ```
 * @property clientToken A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
 * @property instanceArn ARN of the instance of IAM Identity Center.
 * @property name Name of the trusted token issuer.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property trustedTokenIssuerConfiguration A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
 * @property trustedTokenIssuerType Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
 * The following arguments are optional:
 */
public data class TrustedTokenIssuerArgs(
    public val clientToken: Output<String>? = null,
    public val instanceArn: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trustedTokenIssuerConfiguration: Output<TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs>? = null,
    public val trustedTokenIssuerType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.TrustedTokenIssuerArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.TrustedTokenIssuerArgs =
        com.pulumi.aws.ssoadmin.TrustedTokenIssuerArgs.builder()
            .clientToken(clientToken?.applyValue({ args0 -> args0 }))
            .instanceArn(instanceArn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trustedTokenIssuerConfiguration(
                trustedTokenIssuerConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .trustedTokenIssuerType(trustedTokenIssuerType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustedTokenIssuerArgs].
 */
@PulumiTagMarker
public class TrustedTokenIssuerArgsBuilder internal constructor() {
    private var clientToken: Output<String>? = null

    private var instanceArn: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trustedTokenIssuerConfiguration:
        Output<TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs>? = null

    private var trustedTokenIssuerType: Output<String>? = null

    /**
     * @param value A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
     */
    @JvmName("fgiatkhycmkpirpd")
    public suspend fun clientToken(`value`: Output<String>) {
        this.clientToken = value
    }

    /**
     * @param value ARN of the instance of IAM Identity Center.
     */
    @JvmName("vxipgxeeigmdfjfn")
    public suspend fun instanceArn(`value`: Output<String>) {
        this.instanceArn = value
    }

    /**
     * @param value Name of the trusted token issuer.
     */
    @JvmName("okqwmqvukjcdopww")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ngwdhqxrhcetgapc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
     */
    @JvmName("degbxhaojwihlnyh")
    public suspend fun trustedTokenIssuerConfiguration(`value`: Output<TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs>) {
        this.trustedTokenIssuerConfiguration = value
    }

    /**
     * @param value Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
     * The following arguments are optional:
     */
    @JvmName("ojeuplqltnmpjogb")
    public suspend fun trustedTokenIssuerType(`value`: Output<String>) {
        this.trustedTokenIssuerType = value
    }

    /**
     * @param value A unique, case-sensitive ID that you provide to ensure the idempotency of the request. AWS generates a random value when not provided.
     */
    @JvmName("hcwkyrwxgrjtoxkr")
    public suspend fun clientToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientToken = mapped
    }

    /**
     * @param value ARN of the instance of IAM Identity Center.
     */
    @JvmName("anvbxlfrvvkqmkna")
    public suspend fun instanceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceArn = mapped
    }

    /**
     * @param value Name of the trusted token issuer.
     */
    @JvmName("dpirigwiavpvteqn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xaxjjngbignrewcn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("axydpaifmidcsmgu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
     */
    @JvmName("lyqndwwudaiwuyrc")
    public suspend fun trustedTokenIssuerConfiguration(`value`: TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedTokenIssuerConfiguration = mapped
    }

    /**
     * @param argument A block that specifies settings that apply to the trusted token issuer, these change depending on the type you specify in `trusted_token_issuer_type`. Documented below.
     */
    @JvmName("oinnyfmbujvyesgr")
    public suspend fun trustedTokenIssuerConfiguration(argument: suspend TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.trustedTokenIssuerConfiguration = mapped
    }

    /**
     * @param value Specifies the type of the trusted token issuer. Valid values are `OIDC_JWT`
     * The following arguments are optional:
     */
    @JvmName("wmbljuywetmmtyll")
    public suspend fun trustedTokenIssuerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedTokenIssuerType = mapped
    }

    internal fun build(): TrustedTokenIssuerArgs = TrustedTokenIssuerArgs(
        clientToken = clientToken,
        instanceArn = instanceArn,
        name = name,
        tags = tags,
        trustedTokenIssuerConfiguration = trustedTokenIssuerConfiguration,
        trustedTokenIssuerType = trustedTokenIssuerType,
    )
}
