@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property signInOptions Sign-in options for the access portal. See `sign_in_options` below.
 * @property visibility Indicates whether this application is visible in the access portal. Valid values are `ENABLED` and `DISABLED`.
 */
public data class ApplicationPortalOptionsArgs(
    public val signInOptions: Output<ApplicationPortalOptionsSignInOptionsArgs>? = null,
    public val visibility: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsArgs =
        com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsArgs.builder()
            .signInOptions(signInOptions?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .visibility(visibility?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationPortalOptionsArgs].
 */
@PulumiTagMarker
public class ApplicationPortalOptionsArgsBuilder internal constructor() {
    private var signInOptions: Output<ApplicationPortalOptionsSignInOptionsArgs>? = null

    private var visibility: Output<String>? = null

    /**
     * @param value Sign-in options for the access portal. See `sign_in_options` below.
     */
    @JvmName("nxhsndgtauodojxm")
    public suspend fun signInOptions(`value`: Output<ApplicationPortalOptionsSignInOptionsArgs>) {
        this.signInOptions = value
    }

    /**
     * @param value Indicates whether this application is visible in the access portal. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("pvklxydxmgtcnapw")
    public suspend fun visibility(`value`: Output<String>) {
        this.visibility = value
    }

    /**
     * @param value Sign-in options for the access portal. See `sign_in_options` below.
     */
    @JvmName("vbceolwfmrrykvnu")
    public suspend fun signInOptions(`value`: ApplicationPortalOptionsSignInOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signInOptions = mapped
    }

    /**
     * @param argument Sign-in options for the access portal. See `sign_in_options` below.
     */
    @JvmName("cacxuvjgtwedlpwb")
    public suspend fun signInOptions(argument: suspend ApplicationPortalOptionsSignInOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationPortalOptionsSignInOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.signInOptions = mapped
    }

    /**
     * @param value Indicates whether this application is visible in the access portal. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("vwhxiuwvbinnoeho")
    public suspend fun visibility(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.visibility = mapped
    }

    internal fun build(): ApplicationPortalOptionsArgs = ApplicationPortalOptionsArgs(
        signInOptions = signInOptions,
        visibility = visibility,
    )
}
