@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsSignInOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationUrl URL that accepts authentication requests for an application.
 * @property origin Determines how IAM Identity Center navigates the user to the target application.
 * Valid values are `APPLICATION` and `IDENTITY_CENTER`.
 * If `APPLICATION` is set, IAM Identity Center redirects the customer to the configured `application_url`.
 * If `IDENTITY_CENTER` is set, IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
 */
public data class ApplicationPortalOptionsSignInOptionsArgs(
    public val applicationUrl: Output<String>? = null,
    public val origin: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsSignInOptionsArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsSignInOptionsArgs =
        com.pulumi.aws.ssoadmin.inputs.ApplicationPortalOptionsSignInOptionsArgs.builder()
            .applicationUrl(applicationUrl?.applyValue({ args0 -> args0 }))
            .origin(origin.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApplicationPortalOptionsSignInOptionsArgs].
 */
@PulumiTagMarker
public class ApplicationPortalOptionsSignInOptionsArgsBuilder internal constructor() {
    private var applicationUrl: Output<String>? = null

    private var origin: Output<String>? = null

    /**
     * @param value URL that accepts authentication requests for an application.
     */
    @JvmName("kfuujpofflqladsm")
    public suspend fun applicationUrl(`value`: Output<String>) {
        this.applicationUrl = value
    }

    /**
     * @param value Determines how IAM Identity Center navigates the user to the target application.
     * Valid values are `APPLICATION` and `IDENTITY_CENTER`.
     * If `APPLICATION` is set, IAM Identity Center redirects the customer to the configured `application_url`.
     * If `IDENTITY_CENTER` is set, IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
     */
    @JvmName("rdyjmjwmtmslcptl")
    public suspend fun origin(`value`: Output<String>) {
        this.origin = value
    }

    /**
     * @param value URL that accepts authentication requests for an application.
     */
    @JvmName("waefnhhuduafdmjm")
    public suspend fun applicationUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationUrl = mapped
    }

    /**
     * @param value Determines how IAM Identity Center navigates the user to the target application.
     * Valid values are `APPLICATION` and `IDENTITY_CENTER`.
     * If `APPLICATION` is set, IAM Identity Center redirects the customer to the configured `application_url`.
     * If `IDENTITY_CENTER` is set, IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
     */
    @JvmName("vwvoyikkonhegkln")
    public suspend fun origin(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.origin = mapped
    }

    internal fun build(): ApplicationPortalOptionsSignInOptionsArgs =
        ApplicationPortalOptionsSignInOptionsArgs(
            applicationUrl = applicationUrl,
            origin = origin ?: throw PulumiNullFieldException("origin"),
        )
}
