@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsApplicationAssignment.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationArn ARN of the application.
 * @property principalId An identifier for an object in IAM Identity Center, such as a user or group.
 * @property principalType Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
 */
public data class GetApplicationAssignmentsApplicationAssignment(
    public val applicationArn: String,
    public val principalId: String,
    public val principalType: String,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsApplicationAssignment> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsApplicationAssignment =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsApplicationAssignment.builder()
            .applicationArn(applicationArn.let({ args0 -> args0 }))
            .principalId(principalId.let({ args0 -> args0 }))
            .principalType(principalType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationAssignmentsApplicationAssignment].
 */
@PulumiTagMarker
public class GetApplicationAssignmentsApplicationAssignmentBuilder internal constructor() {
    private var applicationArn: String? = null

    private var principalId: String? = null

    private var principalType: String? = null

    /**
     * @param value ARN of the application.
     */
    @JvmName("lxhgxqbfqtdbfred")
    public suspend fun applicationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationArn = mapped
    }

    /**
     * @param value An identifier for an object in IAM Identity Center, such as a user or group.
     */
    @JvmName("yvmtbacnkmcsypfd")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalId = mapped
    }

    /**
     * @param value Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
     */
    @JvmName("ujocxafkqfgpksfp")
    public suspend fun principalType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalType = mapped
    }

    internal fun build(): GetApplicationAssignmentsApplicationAssignment =
        GetApplicationAssignmentsApplicationAssignment(
            applicationArn = applicationArn ?: throw PulumiNullFieldException("applicationArn"),
            principalId = principalId ?: throw PulumiNullFieldException("principalId"),
            principalType = principalType ?: throw PulumiNullFieldException("principalType"),
        )
}
