@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplicationAssignments.
 * @property applicationArn ARN of the application.
 * @property applicationAssignments List of principals assigned to the application. See the `application_assignments` attribute reference below.
 */
public data class GetApplicationAssignmentsPlainArgs(
    public val applicationArn: String,
    public val applicationAssignments: List<GetApplicationAssignmentsApplicationAssignment>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsPlainArgs =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationAssignmentsPlainArgs.builder()
            .applicationArn(applicationArn.let({ args0 -> args0 }))
            .applicationAssignments(
                applicationAssignments?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetApplicationAssignmentsPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationAssignmentsPlainArgsBuilder internal constructor() {
    private var applicationArn: String? = null

    private var applicationAssignments: List<GetApplicationAssignmentsApplicationAssignment>? = null

    /**
     * @param value ARN of the application.
     */
    @JvmName("mwrwfhehkivaahfc")
    public suspend fun applicationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationArn = mapped
    }

    /**
     * @param value List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("agtwyminqvrtmcju")
    public suspend fun applicationAssignments(`value`: List<GetApplicationAssignmentsApplicationAssignment>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.applicationAssignments = mapped
    }

    /**
     * @param argument List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("socxydmmtlcnpawb")
    public suspend fun applicationAssignments(argument: List<suspend GetApplicationAssignmentsApplicationAssignmentBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetApplicationAssignmentsApplicationAssignmentBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.applicationAssignments = mapped
    }

    /**
     * @param argument List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("vovtmclmqwdrxltx")
    public suspend fun applicationAssignments(vararg argument: suspend GetApplicationAssignmentsApplicationAssignmentBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetApplicationAssignmentsApplicationAssignmentBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.applicationAssignments = mapped
    }

    /**
     * @param argument List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("ihnfxunphokquegg")
    public suspend fun applicationAssignments(argument: suspend GetApplicationAssignmentsApplicationAssignmentBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetApplicationAssignmentsApplicationAssignmentBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.applicationAssignments = mapped
    }

    /**
     * @param values List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("qneoyomroipkbfhu")
    public suspend fun applicationAssignments(vararg values: GetApplicationAssignmentsApplicationAssignment) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationAssignments = mapped
    }

    internal fun build(): GetApplicationAssignmentsPlainArgs = GetApplicationAssignmentsPlainArgs(
        applicationArn = applicationArn ?: throw PulumiNullFieldException("applicationArn"),
        applicationAssignments = applicationAssignments,
    )
}
