@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplication.
 * @property applicationArn ARN of the application.
 * @property portalOptions Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
 */
public data class GetApplicationPlainArgs(
    public val applicationArn: String,
    public val portalOptions: List<GetApplicationPortalOption>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationPlainArgs =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationPlainArgs.builder()
            .applicationArn(applicationArn.let({ args0 -> args0 }))
            .portalOptions(
                portalOptions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetApplicationPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationPlainArgsBuilder internal constructor() {
    private var applicationArn: String? = null

    private var portalOptions: List<GetApplicationPortalOption>? = null

    /**
     * @param value ARN of the application.
     */
    @JvmName("adodhwoccocfljql")
    public suspend fun applicationArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationArn = mapped
    }

    /**
     * @param value Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
     */
    @JvmName("thadhrhttlixqtxq")
    public suspend fun portalOptions(`value`: List<GetApplicationPortalOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.portalOptions = mapped
    }

    /**
     * @param argument Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
     */
    @JvmName("ddpeqfjdnvsdfpnb")
    public suspend fun portalOptions(argument: List<suspend GetApplicationPortalOptionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetApplicationPortalOptionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.portalOptions = mapped
    }

    /**
     * @param argument Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
     */
    @JvmName("cifbbaxgqpjncwmd")
    public suspend fun portalOptions(vararg argument: suspend GetApplicationPortalOptionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetApplicationPortalOptionBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.portalOptions = mapped
    }

    /**
     * @param argument Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
     */
    @JvmName("uwqsynoivswoxskd")
    public suspend fun portalOptions(argument: suspend GetApplicationPortalOptionBuilder.() -> Unit) {
        val toBeMapped = listOf(GetApplicationPortalOptionBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.portalOptions = mapped
    }

    /**
     * @param values Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
     */
    @JvmName("ahhipyygtextclvy")
    public suspend fun portalOptions(vararg values: GetApplicationPortalOption) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.portalOptions = mapped
    }

    internal fun build(): GetApplicationPlainArgs = GetApplicationPlainArgs(
        applicationArn = applicationArn ?: throw PulumiNullFieldException("applicationArn"),
        portalOptions = portalOptions,
    )
}
