@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOption.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property signInOptions
 * @property visibility
 */
public data class GetApplicationPortalOption(
    public val signInOptions: List<GetApplicationPortalOptionSignInOption>? = null,
    public val visibility: String,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOption> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOption =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOption.builder()
            .signInOptions(
                signInOptions?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .visibility(visibility.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPortalOption].
 */
@PulumiTagMarker
public class GetApplicationPortalOptionBuilder internal constructor() {
    private var signInOptions: List<GetApplicationPortalOptionSignInOption>? = null

    private var visibility: String? = null

    /**
     * @param value
     */
    @JvmName("ndijjhsmarbmsvmq")
    public suspend fun signInOptions(`value`: List<GetApplicationPortalOptionSignInOption>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.signInOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dvkkaoikerbkrlsg")
    public suspend fun signInOptions(argument: List<suspend GetApplicationPortalOptionSignInOptionBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetApplicationPortalOptionSignInOptionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.signInOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("isqnxspapvlrcdeh")
    public suspend fun signInOptions(vararg argument: suspend GetApplicationPortalOptionSignInOptionBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetApplicationPortalOptionSignInOptionBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.signInOptions = mapped
    }

    /**
     * @param argument
     */
    @JvmName("msaekbwyakfrvaut")
    public suspend fun signInOptions(argument: suspend GetApplicationPortalOptionSignInOptionBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetApplicationPortalOptionSignInOptionBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.signInOptions = mapped
    }

    /**
     * @param values
     */
    @JvmName("ksjmqlgffalyaiyt")
    public suspend fun signInOptions(vararg values: GetApplicationPortalOptionSignInOption) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.signInOptions = mapped
    }

    /**
     * @param value
     */
    @JvmName("crpacufddidhsppg")
    public suspend fun visibility(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.visibility = mapped
    }

    internal fun build(): GetApplicationPortalOption = GetApplicationPortalOption(
        signInOptions = signInOptions,
        visibility = visibility ?: throw PulumiNullFieldException("visibility"),
    )
}
