@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOptionSignInOption.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationUrl
 * @property origin
 */
public data class GetApplicationPortalOptionSignInOption(
    public val applicationUrl: String,
    public val origin: String,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOptionSignInOption> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOptionSignInOption =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationPortalOptionSignInOption.builder()
            .applicationUrl(applicationUrl.let({ args0 -> args0 }))
            .origin(origin.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationPortalOptionSignInOption].
 */
@PulumiTagMarker
public class GetApplicationPortalOptionSignInOptionBuilder internal constructor() {
    private var applicationUrl: String? = null

    private var origin: String? = null

    /**
     * @param value
     */
    @JvmName("qghmflgserfcgitr")
    public suspend fun applicationUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationUrl = mapped
    }

    /**
     * @param value
     */
    @JvmName("nwlxdahnotgkxupb")
    public suspend fun origin(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.origin = mapped
    }

    internal fun build(): GetApplicationPortalOptionSignInOption =
        GetApplicationPortalOptionSignInOption(
            applicationUrl = applicationUrl ?: throw PulumiNullFieldException("applicationUrl"),
            origin = origin ?: throw PulumiNullFieldException("origin"),
        )
}
