@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProvider.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property applicationProviderArn ARN of the application provider.
 * @property displayDatas An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
 * @property federationProtocol Protocol that the application provider uses to perform federation. Valid values are `SAML` and `OAUTH`.
 */
public data class GetApplicationProvidersApplicationProvider(
    public val applicationProviderArn: String,
    public val displayDatas: List<GetApplicationProvidersApplicationProviderDisplayData>? = null,
    public val federationProtocol: String,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProvider> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProvider =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProvider.builder()
            .applicationProviderArn(applicationProviderArn.let({ args0 -> args0 }))
            .displayDatas(
                displayDatas?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .federationProtocol(federationProtocol.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationProvidersApplicationProvider].
 */
@PulumiTagMarker
public class GetApplicationProvidersApplicationProviderBuilder internal constructor() {
    private var applicationProviderArn: String? = null

    private var displayDatas: List<GetApplicationProvidersApplicationProviderDisplayData>? = null

    private var federationProtocol: String? = null

    /**
     * @param value ARN of the application provider.
     */
    @JvmName("ndephsopprhmcqno")
    public suspend fun applicationProviderArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationProviderArn = mapped
    }

    /**
     * @param value An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
     */
    @JvmName("ceapptdljigcqtrm")
    public suspend fun displayDatas(`value`: List<GetApplicationProvidersApplicationProviderDisplayData>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.displayDatas = mapped
    }

    /**
     * @param argument An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
     */
    @JvmName("kbbcvmmwiaxqqltg")
    public suspend fun displayDatas(argument: List<suspend GetApplicationProvidersApplicationProviderDisplayDataBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetApplicationProvidersApplicationProviderDisplayDataBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.displayDatas = mapped
    }

    /**
     * @param argument An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
     */
    @JvmName("mqpiirfvtxgroyad")
    public suspend fun displayDatas(vararg argument: suspend GetApplicationProvidersApplicationProviderDisplayDataBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetApplicationProvidersApplicationProviderDisplayDataBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.displayDatas = mapped
    }

    /**
     * @param argument An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
     */
    @JvmName("svrxnilojkhfvnfq")
    public suspend fun displayDatas(argument: suspend GetApplicationProvidersApplicationProviderDisplayDataBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetApplicationProvidersApplicationProviderDisplayDataBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.displayDatas = mapped
    }

    /**
     * @param values An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
     */
    @JvmName("wqpertgnvxbtsspk")
    public suspend fun displayDatas(vararg values: GetApplicationProvidersApplicationProviderDisplayData) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.displayDatas = mapped
    }

    /**
     * @param value Protocol that the application provider uses to perform federation. Valid values are `SAML` and `OAUTH`.
     */
    @JvmName("yjpmoxtcqqrecwlm")
    public suspend fun federationProtocol(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.federationProtocol = mapped
    }

    internal fun build(): GetApplicationProvidersApplicationProvider =
        GetApplicationProvidersApplicationProvider(
            applicationProviderArn = applicationProviderArn ?: throw
                PulumiNullFieldException("applicationProviderArn"),
            displayDatas = displayDatas,
            federationProtocol = federationProtocol ?: throw PulumiNullFieldException("federationProtocol"),
        )
}
