@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProviderDisplayData.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Description of the application provider.
 * @property displayName Name of the application provider.
 * @property iconUrl URL that points to an icon that represents the application provider.
 */
public data class GetApplicationProvidersApplicationProviderDisplayData(
    public val description: String,
    public val displayName: String,
    public val iconUrl: String,
) :
    ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProviderDisplayData> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProviderDisplayData =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersApplicationProviderDisplayData.builder()
            .description(description.let({ args0 -> args0 }))
            .displayName(displayName.let({ args0 -> args0 }))
            .iconUrl(iconUrl.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationProvidersApplicationProviderDisplayData].
 */
@PulumiTagMarker
public class GetApplicationProvidersApplicationProviderDisplayDataBuilder internal constructor() {
    private var description: String? = null

    private var displayName: String? = null

    private var iconUrl: String? = null

    /**
     * @param value Description of the application provider.
     */
    @JvmName("qvqhpblppsdgpqhf")
    public suspend fun description(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.description = mapped
    }

    /**
     * @param value Name of the application provider.
     */
    @JvmName("epuifolropegsttl")
    public suspend fun displayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.displayName = mapped
    }

    /**
     * @param value URL that points to an icon that represents the application provider.
     */
    @JvmName("nxmcretvevxcmchi")
    public suspend fun iconUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.iconUrl = mapped
    }

    internal fun build(): GetApplicationProvidersApplicationProviderDisplayData =
        GetApplicationProvidersApplicationProviderDisplayData(
            description = description ?: throw PulumiNullFieldException("description"),
            displayName = displayName ?: throw PulumiNullFieldException("displayName"),
            iconUrl = iconUrl ?: throw PulumiNullFieldException("iconUrl"),
        )
}
