@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getApplicationProviders.
 * @property applicationProviders A list of application providers available in the current region. See `application_providers` below.
 */
public data class GetApplicationProvidersPlainArgs(
    public val applicationProviders: List<GetApplicationProvidersApplicationProvider>? = null,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersPlainArgs =
        com.pulumi.aws.ssoadmin.inputs.GetApplicationProvidersPlainArgs.builder()
            .applicationProviders(
                applicationProviders?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetApplicationProvidersPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationProvidersPlainArgsBuilder internal constructor() {
    private var applicationProviders: List<GetApplicationProvidersApplicationProvider>? = null

    /**
     * @param value A list of application providers available in the current region. See `application_providers` below.
     */
    @JvmName("onpoetmrnpfbvjku")
    public suspend fun applicationProviders(`value`: List<GetApplicationProvidersApplicationProvider>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.applicationProviders = mapped
    }

    /**
     * @param argument A list of application providers available in the current region. See `application_providers` below.
     */
    @JvmName("pruqiuiutpegjmaq")
    public suspend fun applicationProviders(argument: List<suspend GetApplicationProvidersApplicationProviderBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetApplicationProvidersApplicationProviderBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.applicationProviders = mapped
    }

    /**
     * @param argument A list of application providers available in the current region. See `application_providers` below.
     */
    @JvmName("qkycohliliialbhh")
    public suspend fun applicationProviders(vararg argument: suspend GetApplicationProvidersApplicationProviderBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetApplicationProvidersApplicationProviderBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.applicationProviders = mapped
    }

    /**
     * @param argument A list of application providers available in the current region. See `application_providers` below.
     */
    @JvmName("kcsbvmdrtcaumwmw")
    public suspend fun applicationProviders(argument: suspend GetApplicationProvidersApplicationProviderBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetApplicationProvidersApplicationProviderBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.applicationProviders = mapped
    }

    /**
     * @param values A list of application providers available in the current region. See `application_providers` below.
     */
    @JvmName("ppapccqcfjrnkbla")
    public suspend fun applicationProviders(vararg values: GetApplicationProvidersApplicationProvider) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationProviders = mapped
    }

    internal fun build(): GetApplicationProvidersPlainArgs = GetApplicationProvidersPlainArgs(
        applicationProviders = applicationProviders,
    )
}
