@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.GetPrincipalApplicationAssignmentsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getPrincipalApplicationAssignments.
 * @property applicationAssignments List of principals assigned to the application. See the `application_assignments` attribute reference below.
 * @property instanceArn ARN of the instance of IAM Identity Center.
 * @property principalId An identifier for an object in IAM Identity Center, such as a user or group.
 * @property principalType Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
 */
public data class GetPrincipalApplicationAssignmentsPlainArgs(
    public val applicationAssignments: List<GetPrincipalApplicationAssignmentsApplicationAssignment>? =
        null,
    public val instanceArn: String,
    public val principalId: String,
    public val principalType: String,
) : ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.GetPrincipalApplicationAssignmentsPlainArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.GetPrincipalApplicationAssignmentsPlainArgs = com.pulumi.aws.ssoadmin.inputs.GetPrincipalApplicationAssignmentsPlainArgs.builder()
        .applicationAssignments(
            applicationAssignments?.let({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                })
            }),
        )
        .instanceArn(instanceArn.let({ args0 -> args0 }))
        .principalId(principalId.let({ args0 -> args0 }))
        .principalType(principalType.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrincipalApplicationAssignmentsPlainArgs].
 */
@PulumiTagMarker
public class GetPrincipalApplicationAssignmentsPlainArgsBuilder internal constructor() {
    private var applicationAssignments: List<GetPrincipalApplicationAssignmentsApplicationAssignment>? =
        null

    private var instanceArn: String? = null

    private var principalId: String? = null

    private var principalType: String? = null

    /**
     * @param value List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("sxvuyhqibxjylaaa")
    public suspend fun applicationAssignments(`value`: List<GetPrincipalApplicationAssignmentsApplicationAssignment>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.applicationAssignments = mapped
    }

    /**
     * @param argument List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("ncjafvwpqcjdylck")
    public suspend fun applicationAssignments(argument: List<suspend GetPrincipalApplicationAssignmentsApplicationAssignmentBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetPrincipalApplicationAssignmentsApplicationAssignmentBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.applicationAssignments = mapped
    }

    /**
     * @param argument List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("wdihkkgfsnyctaxq")
    public suspend fun applicationAssignments(vararg argument: suspend GetPrincipalApplicationAssignmentsApplicationAssignmentBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetPrincipalApplicationAssignmentsApplicationAssignmentBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.applicationAssignments = mapped
    }

    /**
     * @param argument List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("ikilgoqtxsbceaes")
    public suspend fun applicationAssignments(argument: suspend GetPrincipalApplicationAssignmentsApplicationAssignmentBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                GetPrincipalApplicationAssignmentsApplicationAssignmentBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = toBeMapped
        this.applicationAssignments = mapped
    }

    /**
     * @param values List of principals assigned to the application. See the `application_assignments` attribute reference below.
     */
    @JvmName("kiepbeaaipsphlgt")
    public suspend fun applicationAssignments(vararg values: GetPrincipalApplicationAssignmentsApplicationAssignment) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationAssignments = mapped
    }

    /**
     * @param value ARN of the instance of IAM Identity Center.
     */
    @JvmName("qibsojuqqxgrecok")
    public suspend fun instanceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceArn = mapped
    }

    /**
     * @param value An identifier for an object in IAM Identity Center, such as a user or group.
     */
    @JvmName("eenkbwecnlpselhf")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalId = mapped
    }

    /**
     * @param value Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
     */
    @JvmName("gtrhdxlvhotuclbi")
    public suspend fun principalType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalType = mapped
    }

    internal fun build(): GetPrincipalApplicationAssignmentsPlainArgs =
        GetPrincipalApplicationAssignmentsPlainArgs(
            applicationAssignments = applicationAssignments,
            instanceArn = instanceArn ?: throw PulumiNullFieldException("instanceArn"),
            principalId = principalId ?: throw PulumiNullFieldException("principalId"),
            principalType = principalType ?: throw PulumiNullFieldException("principalType"),
        )
}
