@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property sources The identity source to use when mapping a specified attribute to AWS SSO.
 */
public data class InstanceAccessControlAttributesAttributeValueArgs(
    public val sources: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeValueArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeValueArgs =
        com.pulumi.aws.ssoadmin.inputs.InstanceAccessControlAttributesAttributeValueArgs.builder()
            .sources(sources.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [InstanceAccessControlAttributesAttributeValueArgs].
 */
@PulumiTagMarker
public class InstanceAccessControlAttributesAttributeValueArgsBuilder internal constructor() {
    private var sources: Output<List<String>>? = null

    /**
     * @param value The identity source to use when mapping a specified attribute to AWS SSO.
     */
    @JvmName("iwhuesbyoucppehx")
    public suspend fun sources(`value`: Output<List<String>>) {
        this.sources = value
    }

    @JvmName("awewxyuxmjkhwehc")
    public suspend fun sources(vararg values: Output<String>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values The identity source to use when mapping a specified attribute to AWS SSO.
     */
    @JvmName("kciaylhvodvmaehy")
    public suspend fun sources(values: List<Output<String>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value The identity source to use when mapping a specified attribute to AWS SSO.
     */
    @JvmName("llbuefeajfyfjbho")
    public suspend fun sources(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param values The identity source to use when mapping a specified attribute to AWS SSO.
     */
    @JvmName("ygqgnljswrdmdyne")
    public suspend fun sources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    internal fun build(): InstanceAccessControlAttributesAttributeValueArgs =
        InstanceAccessControlAttributesAttributeValueArgs(
            sources = sources ?: throw PulumiNullFieldException("sources"),
        )
}
