@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property customerManagedPolicyReference Specifies the name and path of a customer managed policy. See below.
 * @property managedPolicyArn AWS-managed IAM policy ARN to use as the permissions boundary.
 */
public data class PermissionsBoundaryAttachmentPermissionsBoundaryArgs(
    public val customerManagedPolicyReference: Output<PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs>? =
        null,
    public val managedPolicyArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs =
        com.pulumi.aws.ssoadmin.inputs.PermissionsBoundaryAttachmentPermissionsBoundaryArgs.builder()
            .customerManagedPolicyReference(
                customerManagedPolicyReference?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .managedPolicyArn(managedPolicyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PermissionsBoundaryAttachmentPermissionsBoundaryArgs].
 */
@PulumiTagMarker
public class PermissionsBoundaryAttachmentPermissionsBoundaryArgsBuilder internal constructor() {
    private var customerManagedPolicyReference:
        Output<PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs>? =
        null

    private var managedPolicyArn: Output<String>? = null

    /**
     * @param value Specifies the name and path of a customer managed policy. See below.
     */
    @JvmName("stsncflvsydqtdus")
    public suspend fun customerManagedPolicyReference(`value`: Output<PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs>) {
        this.customerManagedPolicyReference = value
    }

    /**
     * @param value AWS-managed IAM policy ARN to use as the permissions boundary.
     */
    @JvmName("fujloyxfuqwcvnvm")
    public suspend fun managedPolicyArn(`value`: Output<String>) {
        this.managedPolicyArn = value
    }

    /**
     * @param value Specifies the name and path of a customer managed policy. See below.
     */
    @JvmName("tetpgdafgjnmqloj")
    public suspend fun customerManagedPolicyReference(`value`: PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerManagedPolicyReference = mapped
    }

    /**
     * @param argument Specifies the name and path of a customer managed policy. See below.
     */
    @JvmName("lgxbdivitosvqlll")
    public suspend fun customerManagedPolicyReference(argument: suspend PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            PermissionsBoundaryAttachmentPermissionsBoundaryCustomerManagedPolicyReferenceArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.customerManagedPolicyReference = mapped
    }

    /**
     * @param value AWS-managed IAM policy ARN to use as the permissions boundary.
     */
    @JvmName("qqfunferwyjvejjq")
    public suspend fun managedPolicyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedPolicyArn = mapped
    }

    internal fun build(): PermissionsBoundaryAttachmentPermissionsBoundaryArgs =
        PermissionsBoundaryAttachmentPermissionsBoundaryArgs(
            customerManagedPolicyReference = customerManagedPolicyReference,
            managedPolicyArn = managedPolicyArn,
        )
}
