@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property oidcJwtConfiguration A block that describes the settings for a trusted token issuer that works with OpenID Connect (OIDC) by using JSON Web Tokens (JWT). See Documented below below.
 */
public data class TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs(
    public val oidcJwtConfiguration: Output<TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs =
        com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs.builder()
            .oidcJwtConfiguration(
                oidcJwtConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs].
 */
@PulumiTagMarker
public class TrustedTokenIssuerTrustedTokenIssuerConfigurationArgsBuilder internal constructor() {
    private var oidcJwtConfiguration:
        Output<TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs>? = null

    /**
     * @param value A block that describes the settings for a trusted token issuer that works with OpenID Connect (OIDC) by using JSON Web Tokens (JWT). See Documented below below.
     */
    @JvmName("syirrvhgnxhsmssd")
    public suspend fun oidcJwtConfiguration(`value`: Output<TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs>) {
        this.oidcJwtConfiguration = value
    }

    /**
     * @param value A block that describes the settings for a trusted token issuer that works with OpenID Connect (OIDC) by using JSON Web Tokens (JWT). See Documented below below.
     */
    @JvmName("mgrsquuveyadasob")
    public suspend fun oidcJwtConfiguration(`value`: TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidcJwtConfiguration = mapped
    }

    /**
     * @param argument A block that describes the settings for a trusted token issuer that works with OpenID Connect (OIDC) by using JSON Web Tokens (JWT). See Documented below below.
     */
    @JvmName("icgrgaawbwaypfyp")
    public suspend fun oidcJwtConfiguration(argument: suspend TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.oidcJwtConfiguration = mapped
    }

    internal fun build(): TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs =
        TrustedTokenIssuerTrustedTokenIssuerConfigurationArgs(
            oidcJwtConfiguration = oidcJwtConfiguration,
        )
}
