@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.inputs

import com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property claimAttributePath Specifies the path of the source attribute in the JWT from the trusted token issuer.
 * @property identityStoreAttributePath Specifies path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `claim_attribute_path` when a trusted token issuer token is exchanged for an IAM Identity Center token.
 * @property issuerUrl Specifies the URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
 * @property jwksRetrievalOption The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT. Valid values are `OPEN_ID_DISCOVERY`
 */
public data class TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs(
    public val claimAttributePath: Output<String>,
    public val identityStoreAttributePath: Output<String>,
    public val issuerUrl: Output<String>,
    public val jwksRetrievalOption: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs =
        com.pulumi.aws.ssoadmin.inputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs.builder()
            .claimAttributePath(claimAttributePath.applyValue({ args0 -> args0 }))
            .identityStoreAttributePath(identityStoreAttributePath.applyValue({ args0 -> args0 }))
            .issuerUrl(issuerUrl.applyValue({ args0 -> args0 }))
            .jwksRetrievalOption(jwksRetrievalOption.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs].
 */
@PulumiTagMarker
public class TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgsBuilder
internal constructor() {
    private var claimAttributePath: Output<String>? = null

    private var identityStoreAttributePath: Output<String>? = null

    private var issuerUrl: Output<String>? = null

    private var jwksRetrievalOption: Output<String>? = null

    /**
     * @param value Specifies the path of the source attribute in the JWT from the trusted token issuer.
     */
    @JvmName("rqgoaxevakyvlark")
    public suspend fun claimAttributePath(`value`: Output<String>) {
        this.claimAttributePath = value
    }

    /**
     * @param value Specifies path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `claim_attribute_path` when a trusted token issuer token is exchanged for an IAM Identity Center token.
     */
    @JvmName("nrphdjarwkqijiug")
    public suspend fun identityStoreAttributePath(`value`: Output<String>) {
        this.identityStoreAttributePath = value
    }

    /**
     * @param value Specifies the URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
     */
    @JvmName("fdfigsmeybngsqyw")
    public suspend fun issuerUrl(`value`: Output<String>) {
        this.issuerUrl = value
    }

    /**
     * @param value The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT. Valid values are `OPEN_ID_DISCOVERY`
     */
    @JvmName("itupbucrrevvjxwg")
    public suspend fun jwksRetrievalOption(`value`: Output<String>) {
        this.jwksRetrievalOption = value
    }

    /**
     * @param value Specifies the path of the source attribute in the JWT from the trusted token issuer.
     */
    @JvmName("jspcsvsytyrqsncn")
    public suspend fun claimAttributePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.claimAttributePath = mapped
    }

    /**
     * @param value Specifies path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `claim_attribute_path` when a trusted token issuer token is exchanged for an IAM Identity Center token.
     */
    @JvmName("taypnsyjqoyhrude")
    public suspend fun identityStoreAttributePath(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityStoreAttributePath = mapped
    }

    /**
     * @param value Specifies the URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
     */
    @JvmName("cybskjgvkdaudcct")
    public suspend fun issuerUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.issuerUrl = mapped
    }

    /**
     * @param value The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT. Valid values are `OPEN_ID_DISCOVERY`
     */
    @JvmName("mdbktwpnxdsjpqky")
    public suspend fun jwksRetrievalOption(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.jwksRetrievalOption = mapped
    }

    internal fun build(): TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs =
        TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfigurationArgs(
            claimAttributePath = claimAttributePath ?: throw PulumiNullFieldException("claimAttributePath"),
            identityStoreAttributePath = identityStoreAttributePath ?: throw
                PulumiNullFieldException("identityStoreAttributePath"),
            issuerUrl = issuerUrl ?: throw PulumiNullFieldException("issuerUrl"),
            jwksRetrievalOption = jwksRetrievalOption ?: throw PulumiNullFieldException("jwksRetrievalOption"),
        )
}
