@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property signInOptions Sign-in options for the access portal. See `sign_in_options` below.
 * @property visibility Indicates whether this application is visible in the access portal. Valid values are `ENABLED` and `DISABLED`.
 */
public data class ApplicationPortalOptions(
    public val signInOptions: ApplicationPortalOptionsSignInOptions? = null,
    public val visibility: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.ApplicationPortalOptions): ApplicationPortalOptions = ApplicationPortalOptions(
            signInOptions = javaType.signInOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssoadmin.kotlin.outputs.ApplicationPortalOptionsSignInOptions.Companion.toKotlin(args0)
                })
            }).orElse(null),
            visibility = javaType.visibility().map({ args0 -> args0 }).orElse(null),
        )
    }
}
