@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationUrl URL that accepts authentication requests for an application.
 * @property origin Determines how IAM Identity Center navigates the user to the target application.
 * Valid values are `APPLICATION` and `IDENTITY_CENTER`.
 * If `APPLICATION` is set, IAM Identity Center redirects the customer to the configured `application_url`.
 * If `IDENTITY_CENTER` is set, IAM Identity Center uses SAML identity-provider initiated authentication to sign the customer directly into a SAML-based application.
 */
public data class ApplicationPortalOptionsSignInOptions(
    public val applicationUrl: String? = null,
    public val origin: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.ApplicationPortalOptionsSignInOptions): ApplicationPortalOptionsSignInOptions = ApplicationPortalOptionsSignInOptions(
            applicationUrl = javaType.applicationUrl().map({ args0 -> args0 }).orElse(null),
            origin = javaType.origin(),
        )
    }
}
