@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property applicationArn ARN of the application.
 * @property principalId An identifier for an object in IAM Identity Center, such as a user or group.
 * @property principalType Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
 */
public data class GetApplicationAssignmentsApplicationAssignment(
    public val applicationArn: String,
    public val principalId: String,
    public val principalType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetApplicationAssignmentsApplicationAssignment): GetApplicationAssignmentsApplicationAssignment =
            GetApplicationAssignmentsApplicationAssignment(
                applicationArn = javaType.applicationArn(),
                principalId = javaType.principalId(),
                principalType = javaType.principalType(),
            )
    }
}
