@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApplicationAssignments.
 * @property applicationArn ARN of the application.
 * @property applicationAssignments List of principals assigned to the application. See the `application_assignments` attribute reference below.
 * @property id
 */
public data class GetApplicationAssignmentsResult(
    public val applicationArn: String,
    public val applicationAssignments: List<GetApplicationAssignmentsApplicationAssignment>? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetApplicationAssignmentsResult): GetApplicationAssignmentsResult = GetApplicationAssignmentsResult(
            applicationArn = javaType.applicationArn(),
            applicationAssignments = javaType.applicationAssignments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationAssignmentsApplicationAssignment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
