@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property applicationProviderArn ARN of the application provider.
 * @property displayDatas An object describing how IAM Identity Center represents the application provider in the portal. See `display_data` below.
 * @property federationProtocol Protocol that the application provider uses to perform federation. Valid values are `SAML` and `OAUTH`.
 */
public data class GetApplicationProvidersApplicationProvider(
    public val applicationProviderArn: String,
    public val displayDatas: List<GetApplicationProvidersApplicationProviderDisplayData>? = null,
    public val federationProtocol: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetApplicationProvidersApplicationProvider): GetApplicationProvidersApplicationProvider = GetApplicationProvidersApplicationProvider(
            applicationProviderArn = javaType.applicationProviderArn(),
            displayDatas = javaType.displayDatas().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationProvidersApplicationProviderDisplayData.Companion.toKotlin(args0)
                })
            }),
            federationProtocol = javaType.federationProtocol(),
        )
    }
}
