@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property description Description of the application provider.
 * @property displayName Name of the application provider.
 * @property iconUrl URL that points to an icon that represents the application provider.
 */
public data class GetApplicationProvidersApplicationProviderDisplayData(
    public val description: String,
    public val displayName: String,
    public val iconUrl: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetApplicationProvidersApplicationProviderDisplayData): GetApplicationProvidersApplicationProviderDisplayData =
            GetApplicationProvidersApplicationProviderDisplayData(
                description = javaType.description(),
                displayName = javaType.displayName(),
                iconUrl = javaType.iconUrl(),
            )
    }
}
