@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApplicationProviders.
 * @property applicationProviders A list of application providers available in the current region. See `application_providers` below.
 * @property id AWS region.
 */
public data class GetApplicationProvidersResult(
    public val applicationProviders: List<GetApplicationProvidersApplicationProvider>? = null,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetApplicationProvidersResult): GetApplicationProvidersResult = GetApplicationProvidersResult(
            applicationProviders = javaType.applicationProviders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationProvidersApplicationProvider.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
        )
    }
}
