@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getApplication.
 * @property applicationAccount AWS account ID.
 * @property applicationArn
 * @property applicationProviderArn ARN of the application provider.
 * @property description Description of the application.
 * @property id ARN of the application.
 * @property instanceArn ARN of the instance of IAM Identity Center.
 * @property name Name of the application.
 * @property portalOptions Options for the portal associated with an application. See the `aws.ssoadmin.Application` resource documentation. The attributes are the same.
 * @property status Status of the application.
 */
public data class GetApplicationResult(
    public val applicationAccount: String,
    public val applicationArn: String,
    public val applicationProviderArn: String,
    public val description: String,
    public val id: String,
    public val instanceArn: String,
    public val name: String,
    public val portalOptions: List<GetApplicationPortalOption>? = null,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetApplicationResult): GetApplicationResult = GetApplicationResult(
            applicationAccount = javaType.applicationAccount(),
            applicationArn = javaType.applicationArn(),
            applicationProviderArn = javaType.applicationProviderArn(),
            description = javaType.description(),
            id = javaType.id(),
            instanceArn = javaType.instanceArn(),
            name = javaType.name(),
            portalOptions = javaType.portalOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssoadmin.kotlin.outputs.GetApplicationPortalOption.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
        )
    }
}
