@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getInstances.
 * @property arns Set of Amazon Resource Names (ARNs) of the SSO Instances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property identityStoreIds Set of identifiers of the identity stores connected to the SSO Instances.
 */
public data class GetInstancesResult(
    public val arns: List<String>,
    public val id: String,
    public val identityStoreIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetInstancesResult): GetInstancesResult = GetInstancesResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            id = javaType.id(),
            identityStoreIds = javaType.identityStoreIds().map({ args0 -> args0 }),
        )
    }
}
