@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getPermissionSet.
 * @property arn
 * @property createdDate
 * @property description Description of the Permission Set.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property instanceArn
 * @property name
 * @property relayState Relay state URL used to redirect users within the application during the federation authentication process.
 * @property sessionDuration Length of time that the application user sessions are valid in the ISO-8601 standard.
 * @property tags Key-value map of resource tags.
 */
public data class GetPermissionSetResult(
    public val arn: String,
    public val createdDate: String,
    public val description: String,
    public val id: String,
    public val instanceArn: String,
    public val name: String,
    public val relayState: String,
    public val sessionDuration: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetPermissionSetResult): GetPermissionSetResult = GetPermissionSetResult(
            arn = javaType.arn(),
            createdDate = javaType.createdDate(),
            description = javaType.description(),
            id = javaType.id(),
            instanceArn = javaType.instanceArn(),
            name = javaType.name(),
            relayState = javaType.relayState(),
            sessionDuration = javaType.sessionDuration(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
