@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getPrincipalApplicationAssignments.
 * @property applicationAssignments List of principals assigned to the application. See the `application_assignments` attribute reference below.
 * @property id
 * @property instanceArn
 * @property principalId An identifier for an object in IAM Identity Center, such as a user or group.
 * @property principalType Entity type for which the assignment will be created. Valid values are `USER` or `GROUP`.
 */
public data class GetPrincipalApplicationAssignmentsResult(
    public val applicationAssignments: List<GetPrincipalApplicationAssignmentsApplicationAssignment>? =
        null,
    public val id: String,
    public val instanceArn: String,
    public val principalId: String,
    public val principalType: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.GetPrincipalApplicationAssignmentsResult): GetPrincipalApplicationAssignmentsResult = GetPrincipalApplicationAssignmentsResult(
            applicationAssignments = javaType.applicationAssignments().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssoadmin.kotlin.outputs.GetPrincipalApplicationAssignmentsApplicationAssignment.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            instanceArn = javaType.instanceArn(),
            principalId = javaType.principalId(),
            principalType = javaType.principalType(),
        )
    }
}
