@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The name of the attribute associated with your identities in your identity source. This is used to map a specified attribute in your identity source with an attribute in AWS SSO.
 * @property values The value used for mapping a specified attribute to an identity source. See AccessControlAttributeValue
 */
public data class InstanceAccessControlAttributesAttribute(
    public val key: String,
    public val values: List<InstanceAccessControlAttributesAttributeValue>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.InstanceAccessControlAttributesAttribute): InstanceAccessControlAttributesAttribute = InstanceAccessControlAttributesAttribute(
            key = javaType.key(),
            values = javaType.values().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.ssoadmin.kotlin.outputs.InstanceAccessControlAttributesAttributeValue.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
