@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ssoadmin.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property claimAttributePath Specifies the path of the source attribute in the JWT from the trusted token issuer.
 * @property identityStoreAttributePath Specifies path of the destination attribute in a JWT from IAM Identity Center. The attribute mapped by this JMESPath expression is compared against the attribute mapped by `claim_attribute_path` when a trusted token issuer token is exchanged for an IAM Identity Center token.
 * @property issuerUrl Specifies the URL that IAM Identity Center uses for OpenID Discovery. OpenID Discovery is used to obtain the information required to verify the tokens that the trusted token issuer generates.
 * @property jwksRetrievalOption The method that the trusted token issuer can use to retrieve the JSON Web Key Set used to verify a JWT. Valid values are `OPEN_ID_DISCOVERY`
 */
public data class TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration(
    public val claimAttributePath: String,
    public val identityStoreAttributePath: String,
    public val issuerUrl: String,
    public val jwksRetrievalOption: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ssoadmin.outputs.TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration): TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration =
            TrustedTokenIssuerTrustedTokenIssuerConfigurationOidcJwtConfiguration(
                claimAttributePath = javaType.claimAttributePath(),
                identityStoreAttributePath = javaType.identityStoreAttributePath(),
                issuerUrl = javaType.issuerUrl(),
                jwksRetrievalOption = javaType.jwksRetrievalOption(),
            )
    }
}
