@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [CachesIscsiVolume].
 */
@PulumiTagMarker
public class CachesIscsiVolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CachesIscsiVolumeArgs = CachesIscsiVolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CachesIscsiVolumeArgsBuilder.() -> Unit) {
        val builder = CachesIscsiVolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CachesIscsiVolume {
        val builtJavaResource = com.pulumi.aws.storagegateway.CachesIscsiVolume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return CachesIscsiVolume(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway cached iSCSI volume.
 * > **NOTE:** The gateway must have cache added (e.g., via the `aws.storagegateway.Cache` resource) before creating volumes otherwise the Storage Gateway API will return an error.
 * > **NOTE:** The gateway must have an upload buffer added (e.g., via the `aws.storagegateway.UploadBuffer` resource) before the volume is operational to clients, however the Storage Gateway API will allow volume creation without error in that case and return volume status as `UPLOAD BUFFER NOT CONFIGURED`.
 * ## Example Usage
 * > **NOTE:** These examples are referencing the `aws.storagegateway.Cache` resource `gateway_arn` attribute to ensure this provider properly adds cache before creating the volume. If you are not using this method, you may need to declare an expicit dependency (e.g. via `depends_on = [aws_storagegateway_cache&#46;example]`) to ensure proper ordering.
 * ### Create Empty Cached iSCSI Volume
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.CachesIscsiVolume("example", {
 *     gatewayArn: exampleAwsStoragegatewayCache.gatewayArn,
 *     networkInterfaceId: exampleAwsInstance.privateIp,
 *     targetName: "example",
 *     volumeSizeInBytes: 5368709120,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.CachesIscsiVolume("example",
 *     gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
 *     network_interface_id=example_aws_instance["privateIp"],
 *     target_name="example",
 *     volume_size_in_bytes=5368709120)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.CachesIscsiVolume("example", new()
 *     {
 *         GatewayArn = exampleAwsStoragegatewayCache.GatewayArn,
 *         NetworkInterfaceId = exampleAwsInstance.PrivateIp,
 *         TargetName = "example",
 *         VolumeSizeInBytes = 5368709120,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewCachesIscsiVolume(ctx, "example", &storagegateway.CachesIscsiVolumeArgs{
 * 			GatewayArn:         pulumi.Any(exampleAwsStoragegatewayCache.GatewayArn),
 * 			NetworkInterfaceId: pulumi.Any(exampleAwsInstance.PrivateIp),
 * 			TargetName:         pulumi.String("example"),
 * 			VolumeSizeInBytes:  pulumi.Int(5368709120),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolume;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachesIscsiVolume("example", CachesIscsiVolumeArgs.builder()
 *             .gatewayArn(exampleAwsStoragegatewayCache.gatewayArn())
 *             .networkInterfaceId(exampleAwsInstance.privateIp())
 *             .targetName("example")
 *             .volumeSizeInBytes(5368709120)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:CachesIscsiVolume
 *     properties:
 *       gatewayArn: ${exampleAwsStoragegatewayCache.gatewayArn}
 *       networkInterfaceId: ${exampleAwsInstance.privateIp}
 *       targetName: example
 *       volumeSizeInBytes: 5.36870912e+09 # 5 GB
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create Cached iSCSI Volume From Snapshot
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.CachesIscsiVolume("example", {
 *     gatewayArn: exampleAwsStoragegatewayCache.gatewayArn,
 *     networkInterfaceId: exampleAwsInstance.privateIp,
 *     snapshotId: exampleAwsEbsSnapshot.id,
 *     targetName: "example",
 *     volumeSizeInBytes: exampleAwsEbsSnapshot.volumeSize * 1024 * 1024 * 1024,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.CachesIscsiVolume("example",
 *     gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
 *     network_interface_id=example_aws_instance["privateIp"],
 *     snapshot_id=example_aws_ebs_snapshot["id"],
 *     target_name="example",
 *     volume_size_in_bytes=example_aws_ebs_snapshot["volumeSize"] * 1024 * 1024 * 1024)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.CachesIscsiVolume("example", new()
 *     {
 *         GatewayArn = exampleAwsStoragegatewayCache.GatewayArn,
 *         NetworkInterfaceId = exampleAwsInstance.PrivateIp,
 *         SnapshotId = exampleAwsEbsSnapshot.Id,
 *         TargetName = "example",
 *         VolumeSizeInBytes = exampleAwsEbsSnapshot.VolumeSize * 1024 * 1024 * 1024,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewCachesIscsiVolume(ctx, "example", &storagegateway.CachesIscsiVolumeArgs{
 * 			GatewayArn:         pulumi.Any(exampleAwsStoragegatewayCache.GatewayArn),
 * 			NetworkInterfaceId: pulumi.Any(exampleAwsInstance.PrivateIp),
 * 			SnapshotId:         pulumi.Any(exampleAwsEbsSnapshot.Id),
 * 			TargetName:         pulumi.String("example"),
 * 			VolumeSizeInBytes:  int(exampleAwsEbsSnapshot.VolumeSize * 1024 * 1024 * 1024),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolume;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachesIscsiVolume("example", CachesIscsiVolumeArgs.builder()
 *             .gatewayArn(exampleAwsStoragegatewayCache.gatewayArn())
 *             .networkInterfaceId(exampleAwsInstance.privateIp())
 *             .snapshotId(exampleAwsEbsSnapshot.id())
 *             .targetName("example")
 *             .volumeSizeInBytes(exampleAwsEbsSnapshot.volumeSize() * 1024 * 1024 * 1024)
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create Cached iSCSI Volume From Source Volume
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.CachesIscsiVolume("example", {
 *     gatewayArn: exampleAwsStoragegatewayCache.gatewayArn,
 *     networkInterfaceId: exampleAwsInstance.privateIp,
 *     sourceVolumeArn: existing.arn,
 *     targetName: "example",
 *     volumeSizeInBytes: existing.volumeSizeInBytes,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.CachesIscsiVolume("example",
 *     gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
 *     network_interface_id=example_aws_instance["privateIp"],
 *     source_volume_arn=existing["arn"],
 *     target_name="example",
 *     volume_size_in_bytes=existing["volumeSizeInBytes"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.CachesIscsiVolume("example", new()
 *     {
 *         GatewayArn = exampleAwsStoragegatewayCache.GatewayArn,
 *         NetworkInterfaceId = exampleAwsInstance.PrivateIp,
 *         SourceVolumeArn = existing.Arn,
 *         TargetName = "example",
 *         VolumeSizeInBytes = existing.VolumeSizeInBytes,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewCachesIscsiVolume(ctx, "example", &storagegateway.CachesIscsiVolumeArgs{
 * 			GatewayArn:         pulumi.Any(exampleAwsStoragegatewayCache.GatewayArn),
 * 			NetworkInterfaceId: pulumi.Any(exampleAwsInstance.PrivateIp),
 * 			SourceVolumeArn:    pulumi.Any(existing.Arn),
 * 			TargetName:         pulumi.String("example"),
 * 			VolumeSizeInBytes:  pulumi.Any(existing.VolumeSizeInBytes),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolume;
 * import com.pulumi.aws.storagegateway.CachesIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CachesIscsiVolume("example", CachesIscsiVolumeArgs.builder()
 *             .gatewayArn(exampleAwsStoragegatewayCache.gatewayArn())
 *             .networkInterfaceId(exampleAwsInstance.privateIp())
 *             .sourceVolumeArn(existing.arn())
 *             .targetName("example")
 *             .volumeSizeInBytes(existing.volumeSizeInBytes())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:CachesIscsiVolume
 *     properties:
 *       gatewayArn: ${exampleAwsStoragegatewayCache.gatewayArn}
 *       networkInterfaceId: ${exampleAwsInstance.privateIp}
 *       sourceVolumeArn: ${existing.arn}
 *       targetName: example
 *       volumeSizeInBytes: ${existing.volumeSizeInBytes}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_cached_iscsi_volume` using the volume Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/cachesIscsiVolume:CachesIscsiVolume example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678
 * ```
 */
public class CachesIscsiVolume internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.CachesIscsiVolume,
) : KotlinCustomResource(javaResource, CachesIscsiVolumeMapper) {
    /**
     * Volume Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678`.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether mutual CHAP is enabled for the iSCSI target.
     */
    public val chapEnabled: Output<Boolean>
        get() = javaResource.chapEnabled().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })

    /**
     * Set to `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3.
     */
    public val kmsEncrypted: Output<Boolean>?
        get() = javaResource.kmsEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. Is required when `kms_encrypted` is set.
     */
    public val kmsKey: Output<String>?
        get() = javaResource.kmsKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Logical disk number.
     */
    public val lunNumber: Output<Int>
        get() = javaResource.lunNumber().applyValue({ args0 -> args0 })

    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The port used to communicate with iSCSI targets.
     */
    public val networkInterfacePort: Output<Int>
        get() = javaResource.networkInterfacePort().applyValue({ args0 -> args0 })

    /**
     * The snapshot ID of the snapshot to restore as the new cached volumeE.g., `snap-1122aabb`.
     */
    public val snapshotId: Output<String>?
        get() = javaResource.snapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN for an existing volume. Specifying this ARN makes the new volume into an exact copy of the specified existing volume's latest recovery point. The `volume_size_in_bytes` value for this new volume must be equal to or larger than the size of the existing volume, in bytes.
     */
    public val sourceVolumeArn: Output<String>?
        get() = javaResource.sourceVolumeArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Target Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/target/iqn.1997-05.com.amazon:TargetName`.
     */
    public val targetArn: Output<String>
        get() = javaResource.targetArn().applyValue({ args0 -> args0 })

    /**
     * The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     */
    public val targetName: Output<String>
        get() = javaResource.targetName().applyValue({ args0 -> args0 })

    /**
     * Volume Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678`.
     */
    public val volumeArn: Output<String>
        get() = javaResource.volumeArn().applyValue({ args0 -> args0 })

    /**
     * Volume ID, e.g., `vol-12345678`.
     */
    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })

    /**
     * The size of the volume in bytes.
     */
    public val volumeSizeInBytes: Output<Int>
        get() = javaResource.volumeSizeInBytes().applyValue({ args0 -> args0 })
}

public object CachesIscsiVolumeMapper : ResourceMapper<CachesIscsiVolume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.CachesIscsiVolume::class == javaResource::class

    override fun map(javaResource: Resource): CachesIscsiVolume = CachesIscsiVolume(
        javaResource as
            com.pulumi.aws.storagegateway.CachesIscsiVolume,
    )
}

/**
 * @see [CachesIscsiVolume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CachesIscsiVolume].
 */
public suspend fun cachesIscsiVolume(
    name: String,
    block: suspend CachesIscsiVolumeResourceBuilder.() -> Unit,
): CachesIscsiVolume {
    val builder = CachesIscsiVolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CachesIscsiVolume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cachesIscsiVolume(name: String): CachesIscsiVolume {
    val builder = CachesIscsiVolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
