@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.NfsFileShareArgs.builder
import com.pulumi.aws.storagegateway.kotlin.inputs.NfsFileShareCacheAttributesArgs
import com.pulumi.aws.storagegateway.kotlin.inputs.NfsFileShareCacheAttributesArgsBuilder
import com.pulumi.aws.storagegateway.kotlin.inputs.NfsFileShareNfsFileShareDefaultsArgs
import com.pulumi.aws.storagegateway.kotlin.inputs.NfsFileShareNfsFileShareDefaultsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway NFS File Share.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.NfsFileShare("example", {
 *     clientLists: ["0&#46;0&#46;0&#46;0/0"],
 *     gatewayArn: exampleAwsStoragegatewayGateway.arn,
 *     locationArn: exampleAwsS3Bucket.arn,
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.NfsFileShare("example",
 *     client_lists=["0&#46;0&#46;0&#46;0/0"],
 *     gateway_arn=example_aws_storagegateway_gateway["arn"],
 *     location_arn=example_aws_s3_bucket["arn"],
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.NfsFileShare("example", new()
 *     {
 *         ClientLists = new[]
 *         {
 *             "0.0.0.0/0",
 *         },
 *         GatewayArn = exampleAwsStoragegatewayGateway.Arn,
 *         LocationArn = exampleAwsS3Bucket.Arn,
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewNfsFileShare(ctx, "example", &storagegateway.NfsFileShareArgs{
 * 			ClientLists: pulumi.StringArray{
 * 				pulumi.String("0.0.0.0/0"),
 * 			},
 * 			GatewayArn:  pulumi.Any(exampleAwsStoragegatewayGateway.Arn),
 * 			LocationArn: pulumi.Any(exampleAwsS3Bucket.Arn),
 * 			RoleArn:     pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.NfsFileShare;
 * import com.pulumi.aws.storagegateway.NfsFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NfsFileShare("example", NfsFileShareArgs.builder()
 *             .clientLists("0.0.0.0/0")
 *             .gatewayArn(exampleAwsStoragegatewayGateway.arn())
 *             .locationArn(exampleAwsS3Bucket.arn())
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:NfsFileShare
 *     properties:
 *       clientLists:
 *         - 0.0.0.0/0
 *       gatewayArn: ${exampleAwsStoragegatewayGateway.arn}
 *       locationArn: ${exampleAwsS3Bucket.arn}
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_nfs_file_share` using the NFS File Share Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/nfsFileShare:NfsFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
 * ```
 * @property auditDestinationArn The Amazon Resource Name (ARN) of the storage used for audit logs.
 * @property bucketRegion The region of the S3 bucket used by the file share. Required when specifying `vpc_endpoint_dns_name`.
 * @property cacheAttributes Refresh cache information. see Cache Attributes for more details.
 * @property clientLists The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0&#46;0&#46;0&#46;0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
 * @property defaultStorageClass The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
 * @property fileShareName The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
 * @property gatewayArn Amazon Resource Name (ARN) of the file gateway.
 * @property guessMimeTypeEnabled Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
 * @property kmsEncrypted Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
 * @property kmsKeyArn Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
 * @property locationArn The ARN of the backed storage used for storing file data.
 * @property nfsFileShareDefaults Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
 * @property notificationPolicy The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
 * @property objectAcl Access Control List permission for S3 objects. Defaults to `private`.
 * @property readOnly Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
 * @property requesterPays Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
 * @property roleArn The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
 * @property squash Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcEndpointDnsName The DNS name of the VPC endpoint for S3 PrivateLink.
 */
public data class NfsFileShareArgs(
    public val auditDestinationArn: Output<String>? = null,
    public val bucketRegion: Output<String>? = null,
    public val cacheAttributes: Output<NfsFileShareCacheAttributesArgs>? = null,
    public val clientLists: Output<List<String>>? = null,
    public val defaultStorageClass: Output<String>? = null,
    public val fileShareName: Output<String>? = null,
    public val gatewayArn: Output<String>? = null,
    public val guessMimeTypeEnabled: Output<Boolean>? = null,
    public val kmsEncrypted: Output<Boolean>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val locationArn: Output<String>? = null,
    public val nfsFileShareDefaults: Output<NfsFileShareNfsFileShareDefaultsArgs>? = null,
    public val notificationPolicy: Output<String>? = null,
    public val objectAcl: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
    public val requesterPays: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val squash: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcEndpointDnsName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.NfsFileShareArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.NfsFileShareArgs =
        com.pulumi.aws.storagegateway.NfsFileShareArgs.builder()
            .auditDestinationArn(auditDestinationArn?.applyValue({ args0 -> args0 }))
            .bucketRegion(bucketRegion?.applyValue({ args0 -> args0 }))
            .cacheAttributes(cacheAttributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clientLists(clientLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .defaultStorageClass(defaultStorageClass?.applyValue({ args0 -> args0 }))
            .fileShareName(fileShareName?.applyValue({ args0 -> args0 }))
            .gatewayArn(gatewayArn?.applyValue({ args0 -> args0 }))
            .guessMimeTypeEnabled(guessMimeTypeEnabled?.applyValue({ args0 -> args0 }))
            .kmsEncrypted(kmsEncrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .locationArn(locationArn?.applyValue({ args0 -> args0 }))
            .nfsFileShareDefaults(
                nfsFileShareDefaults?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .notificationPolicy(notificationPolicy?.applyValue({ args0 -> args0 }))
            .objectAcl(objectAcl?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .requesterPays(requesterPays?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .squash(squash?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcEndpointDnsName(vpcEndpointDnsName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NfsFileShareArgs].
 */
@PulumiTagMarker
public class NfsFileShareArgsBuilder internal constructor() {
    private var auditDestinationArn: Output<String>? = null

    private var bucketRegion: Output<String>? = null

    private var cacheAttributes: Output<NfsFileShareCacheAttributesArgs>? = null

    private var clientLists: Output<List<String>>? = null

    private var defaultStorageClass: Output<String>? = null

    private var fileShareName: Output<String>? = null

    private var gatewayArn: Output<String>? = null

    private var guessMimeTypeEnabled: Output<Boolean>? = null

    private var kmsEncrypted: Output<Boolean>? = null

    private var kmsKeyArn: Output<String>? = null

    private var locationArn: Output<String>? = null

    private var nfsFileShareDefaults: Output<NfsFileShareNfsFileShareDefaultsArgs>? = null

    private var notificationPolicy: Output<String>? = null

    private var objectAcl: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    private var requesterPays: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var squash: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcEndpointDnsName: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    @JvmName("meglpjshfbllnkpq")
    public suspend fun auditDestinationArn(`value`: Output<String>) {
        this.auditDestinationArn = value
    }

    /**
     * @param value The region of the S3 bucket used by the file share. Required when specifying `vpc_endpoint_dns_name`.
     */
    @JvmName("pydikuybbkmqwofx")
    public suspend fun bucketRegion(`value`: Output<String>) {
        this.bucketRegion = value
    }

    /**
     * @param value Refresh cache information. see Cache Attributes for more details.
     */
    @JvmName("tnlqifiyjuqitaic")
    public suspend fun cacheAttributes(`value`: Output<NfsFileShareCacheAttributesArgs>) {
        this.cacheAttributes = value
    }

    /**
     * @param value The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0&#46;0&#46;0&#46;0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
     */
    @JvmName("ydyxlseoiqvxdelg")
    public suspend fun clientLists(`value`: Output<List<String>>) {
        this.clientLists = value
    }

    @JvmName("mfsmovgvljskmqxc")
    public suspend fun clientLists(vararg values: Output<String>) {
        this.clientLists = Output.all(values.asList())
    }

    /**
     * @param values The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0&#46;0&#46;0&#46;0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
     */
    @JvmName("gvkdfxdwmdeijioj")
    public suspend fun clientLists(values: List<Output<String>>) {
        this.clientLists = Output.all(values)
    }

    /**
     * @param value The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     */
    @JvmName("dstdgmeopsiimlpr")
    public suspend fun defaultStorageClass(`value`: Output<String>) {
        this.defaultStorageClass = value
    }

    /**
     * @param value The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     */
    @JvmName("jnwwjdllqpvrpjav")
    public suspend fun fileShareName(`value`: Output<String>) {
        this.fileShareName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the file gateway.
     */
    @JvmName("ljoptorbkjeopcdq")
    public suspend fun gatewayArn(`value`: Output<String>) {
        this.gatewayArn = value
    }

    /**
     * @param value Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     */
    @JvmName("aogmskuijfypwmcp")
    public suspend fun guessMimeTypeEnabled(`value`: Output<Boolean>) {
        this.guessMimeTypeEnabled = value
    }

    /**
     * @param value Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     */
    @JvmName("qgeoveshpaqspsjo")
    public suspend fun kmsEncrypted(`value`: Output<Boolean>) {
        this.kmsEncrypted = value
    }

    /**
     * @param value Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     */
    @JvmName("ubnhumhdstjrdlfn")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The ARN of the backed storage used for storing file data.
     */
    @JvmName("augxfllfxxlxubeo")
    public suspend fun locationArn(`value`: Output<String>) {
        this.locationArn = value
    }

    /**
     * @param value Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
     */
    @JvmName("mrqhshekvjswxkpj")
    public suspend fun nfsFileShareDefaults(`value`: Output<NfsFileShareNfsFileShareDefaultsArgs>) {
        this.nfsFileShareDefaults = value
    }

    /**
     * @param value The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     */
    @JvmName("ocstwlvswuctrhkp")
    public suspend fun notificationPolicy(`value`: Output<String>) {
        this.notificationPolicy = value
    }

    /**
     * @param value Access Control List permission for S3 objects. Defaults to `private`.
     */
    @JvmName("uvqcwltqgnuqthcb")
    public suspend fun objectAcl(`value`: Output<String>) {
        this.objectAcl = value
    }

    /**
     * @param value Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     */
    @JvmName("mkyurxtswokintte")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     */
    @JvmName("qjamyqmdwfpxgtie")
    public suspend fun requesterPays(`value`: Output<Boolean>) {
        this.requesterPays = value
    }

    /**
     * @param value The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     */
    @JvmName("jhpchhmimsiqhrqo")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
     */
    @JvmName("vhuxsrfaosrnwgjm")
    public suspend fun squash(`value`: Output<String>) {
        this.squash = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jcoxlhfyvmvchqrw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The DNS name of the VPC endpoint for S3 PrivateLink.
     */
    @JvmName("lhtlvvekrjprdduq")
    public suspend fun vpcEndpointDnsName(`value`: Output<String>) {
        this.vpcEndpointDnsName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the storage used for audit logs.
     */
    @JvmName("xgintpvfapsvhljx")
    public suspend fun auditDestinationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditDestinationArn = mapped
    }

    /**
     * @param value The region of the S3 bucket used by the file share. Required when specifying `vpc_endpoint_dns_name`.
     */
    @JvmName("lgyqbsvtkdvhqyqq")
    public suspend fun bucketRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketRegion = mapped
    }

    /**
     * @param value Refresh cache information. see Cache Attributes for more details.
     */
    @JvmName("rrhjkenolthdhttc")
    public suspend fun cacheAttributes(`value`: NfsFileShareCacheAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheAttributes = mapped
    }

    /**
     * @param argument Refresh cache information. see Cache Attributes for more details.
     */
    @JvmName("vajnwjsjqnknthbu")
    public suspend fun cacheAttributes(argument: suspend NfsFileShareCacheAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = NfsFileShareCacheAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cacheAttributes = mapped
    }

    /**
     * @param value The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0&#46;0&#46;0&#46;0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
     */
    @JvmName("pytaelhfuwvxtawp")
    public suspend fun clientLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientLists = mapped
    }

    /**
     * @param values The list of clients that are allowed to access the file gateway. The list must contain either valid IP addresses or valid CIDR blocks. Set to `["0&#46;0&#46;0&#46;0/0"]` to not limit access. Minimum 1 item. Maximum 100 items.
     */
    @JvmName("qeedfvdyetibkboc")
    public suspend fun clientLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientLists = mapped
    }

    /**
     * @param value The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     */
    @JvmName("adtodrvutgchlxft")
    public suspend fun defaultStorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultStorageClass = mapped
    }

    /**
     * @param value The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     */
    @JvmName("aymuruyqowvsphit")
    public suspend fun fileShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileShareName = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the file gateway.
     */
    @JvmName("effyrgbkjvseivos")
    public suspend fun gatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayArn = mapped
    }

    /**
     * @param value Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     */
    @JvmName("ccynxslljgynyivx")
    public suspend fun guessMimeTypeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guessMimeTypeEnabled = mapped
    }

    /**
     * @param value Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     */
    @JvmName("wxubukxjvktuwwnv")
    public suspend fun kmsEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncrypted = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     */
    @JvmName("itsmghbarwjaupbb")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The ARN of the backed storage used for storing file data.
     */
    @JvmName("xfgnqymqbrevwgvi")
    public suspend fun locationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationArn = mapped
    }

    /**
     * @param value Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
     */
    @JvmName("vuxvaismpiemyjuc")
    public suspend fun nfsFileShareDefaults(`value`: NfsFileShareNfsFileShareDefaultsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsFileShareDefaults = mapped
    }

    /**
     * @param argument Nested argument with file share default values. More information below. see NFS File Share Defaults for more details.
     */
    @JvmName("tbmavtnsnhrhxumv")
    public suspend fun nfsFileShareDefaults(argument: suspend NfsFileShareNfsFileShareDefaultsArgsBuilder.() -> Unit) {
        val toBeMapped = NfsFileShareNfsFileShareDefaultsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nfsFileShareDefaults = mapped
    }

    /**
     * @param value The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     */
    @JvmName("wpghqeucmeommebo")
    public suspend fun notificationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationPolicy = mapped
    }

    /**
     * @param value Access Control List permission for S3 objects. Defaults to `private`.
     */
    @JvmName("ujigrqujlntsyjim")
    public suspend fun objectAcl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectAcl = mapped
    }

    /**
     * @param value Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     */
    @JvmName("doxvtqthivyllico")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     */
    @JvmName("tbmeectqdausvnsb")
    public suspend fun requesterPays(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requesterPays = mapped
    }

    /**
     * @param value The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     */
    @JvmName("wqlqspfhsnnketsb")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Maps a user to anonymous user. Defaults to `RootSquash`. Valid values: `RootSquash` (only root is mapped to anonymous user), `NoSquash` (no one is mapped to anonymous user), `AllSquash` (everyone is mapped to anonymous user)
     */
    @JvmName("lmombcmypjdlsakt")
    public suspend fun squash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.squash = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mskbwrqvenrysqwy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yhmlyandlrwrrenv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The DNS name of the VPC endpoint for S3 PrivateLink.
     */
    @JvmName("wgwclklhdupktnbc")
    public suspend fun vpcEndpointDnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointDnsName = mapped
    }

    internal fun build(): NfsFileShareArgs = NfsFileShareArgs(
        auditDestinationArn = auditDestinationArn,
        bucketRegion = bucketRegion,
        cacheAttributes = cacheAttributes,
        clientLists = clientLists,
        defaultStorageClass = defaultStorageClass,
        fileShareName = fileShareName,
        gatewayArn = gatewayArn,
        guessMimeTypeEnabled = guessMimeTypeEnabled,
        kmsEncrypted = kmsEncrypted,
        kmsKeyArn = kmsKeyArn,
        locationArn = locationArn,
        nfsFileShareDefaults = nfsFileShareDefaults,
        notificationPolicy = notificationPolicy,
        objectAcl = objectAcl,
        readOnly = readOnly,
        requesterPays = requesterPays,
        roleArn = roleArn,
        squash = squash,
        tags = tags,
        vpcEndpointDnsName = vpcEndpointDnsName,
    )
}
