@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.kotlin.outputs.SmbFileShareCacheAttributes
import com.pulumi.aws.storagegateway.kotlin.outputs.SmbFileShareCacheAttributes.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [SmbFileShare].
 */
@PulumiTagMarker
public class SmbFileShareResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SmbFileShareArgs = SmbFileShareArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SmbFileShareArgsBuilder.() -> Unit) {
        val builder = SmbFileShareArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SmbFileShare {
        val builtJavaResource = com.pulumi.aws.storagegateway.SmbFileShare(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SmbFileShare(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway SMB File Share.
 * ## Example Usage
 * ### Active Directory Authentication
 * > **NOTE:** The gateway must have already joined the Active Directory domain prior to SMB file share creationE.g., via "SMB Settings" in the AWS Storage Gateway console or `smb_active_directory_settings` in the `aws.storagegateway.Gateway` resource.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.SmbFileShare("example", {
 *     authentication: "ActiveDirectory",
 *     gatewayArn: exampleAwsStoragegatewayGateway.arn,
 *     locationArn: exampleAwsS3Bucket.arn,
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.SmbFileShare("example",
 *     authentication="ActiveDirectory",
 *     gateway_arn=example_aws_storagegateway_gateway["arn"],
 *     location_arn=example_aws_s3_bucket["arn"],
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.SmbFileShare("example", new()
 *     {
 *         Authentication = "ActiveDirectory",
 *         GatewayArn = exampleAwsStoragegatewayGateway.Arn,
 *         LocationArn = exampleAwsS3Bucket.Arn,
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewSmbFileShare(ctx, "example", &storagegateway.SmbFileShareArgs{
 * 			Authentication: pulumi.String("ActiveDirectory"),
 * 			GatewayArn:     pulumi.Any(exampleAwsStoragegatewayGateway.Arn),
 * 			LocationArn:    pulumi.Any(exampleAwsS3Bucket.Arn),
 * 			RoleArn:        pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.SmbFileShare;
 * import com.pulumi.aws.storagegateway.SmbFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SmbFileShare("example", SmbFileShareArgs.builder()
 *             .authentication("ActiveDirectory")
 *             .gatewayArn(exampleAwsStoragegatewayGateway.arn())
 *             .locationArn(exampleAwsS3Bucket.arn())
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:SmbFileShare
 *     properties:
 *       authentication: ActiveDirectory
 *       gatewayArn: ${exampleAwsStoragegatewayGateway.arn}
 *       locationArn: ${exampleAwsS3Bucket.arn}
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Guest Authentication
 * > **NOTE:** The gateway must have already had the SMB guest password set prior to SMB file share creationE.g., via "SMB Settings" in the AWS Storage Gateway console or `smb_guest_password` in the `aws.storagegateway.Gateway` resource.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.SmbFileShare("example", {
 *     authentication: "GuestAccess",
 *     gatewayArn: exampleAwsStoragegatewayGateway.arn,
 *     locationArn: exampleAwsS3Bucket.arn,
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.SmbFileShare("example",
 *     authentication="GuestAccess",
 *     gateway_arn=example_aws_storagegateway_gateway["arn"],
 *     location_arn=example_aws_s3_bucket["arn"],
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.SmbFileShare("example", new()
 *     {
 *         Authentication = "GuestAccess",
 *         GatewayArn = exampleAwsStoragegatewayGateway.Arn,
 *         LocationArn = exampleAwsS3Bucket.Arn,
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewSmbFileShare(ctx, "example", &storagegateway.SmbFileShareArgs{
 * 			Authentication: pulumi.String("GuestAccess"),
 * 			GatewayArn:     pulumi.Any(exampleAwsStoragegatewayGateway.Arn),
 * 			LocationArn:    pulumi.Any(exampleAwsS3Bucket.Arn),
 * 			RoleArn:        pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.SmbFileShare;
 * import com.pulumi.aws.storagegateway.SmbFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SmbFileShare("example", SmbFileShareArgs.builder()
 *             .authentication("GuestAccess")
 *             .gatewayArn(exampleAwsStoragegatewayGateway.arn())
 *             .locationArn(exampleAwsS3Bucket.arn())
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:SmbFileShare
 *     properties:
 *       authentication: GuestAccess
 *       gatewayArn: ${exampleAwsStoragegatewayGateway.arn}
 *       locationArn: ${exampleAwsS3Bucket.arn}
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_smb_file_share` using the SMB File Share Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/smbFileShare:SmbFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
 * ```
 */
public class SmbFileShare internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.SmbFileShare,
) : KotlinCustomResource(javaResource, SmbFileShareMapper) {
    /**
     * The files and folders on this share will only be visible to users with read access. Default value is `false`.
     */
    public val accessBasedEnumeration: Output<Boolean>?
        get() = javaResource.accessBasedEnumeration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    public val adminUserLists: Output<List<String>>?
        get() = javaResource.adminUserLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of the SMB File Share.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
     */
    public val auditDestinationArn: Output<String>?
        get() = javaResource.auditDestinationArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
     */
    public val authentication: Output<String>?
        get() = javaResource.authentication().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
     */
    public val bucketRegion: Output<String>?
        get() = javaResource.bucketRegion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Refresh cache information. see `cache_attributes` Block for more details.
     * **Note:** If you have previously included a `cache_attributes` block in your configuration, removing it will not reset the refresh cache value and the previous value will remain. You must explicitly set a new value to change it.
     */
    public val cacheAttributes: Output<SmbFileShareCacheAttributes>?
        get() = javaResource.cacheAttributes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     */
    public val caseSensitivity: Output<String>?
        get() = javaResource.caseSensitivity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     */
    public val defaultStorageClass: Output<String>?
        get() = javaResource.defaultStorageClass().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     */
    public val fileShareName: Output<String>
        get() = javaResource.fileShareName().applyValue({ args0 -> args0 })

    /**
     * ID of the SMB File Share.
     */
    public val fileshareId: Output<String>
        get() = javaResource.fileshareId().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the file gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })

    /**
     * Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     */
    public val guessMimeTypeEnabled: Output<Boolean>?
        get() = javaResource.guessMimeTypeEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    public val invalidUserLists: Output<List<String>>?
        get() = javaResource.invalidUserLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     */
    public val kmsEncrypted: Output<Boolean>?
        get() = javaResource.kmsEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     */
    public val kmsKeyArn: Output<String>?
        get() = javaResource.kmsKeyArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The ARN of the backed storage used for storing file data.
     */
    public val locationArn: Output<String>
        get() = javaResource.locationArn().applyValue({ args0 -> args0 })

    /**
     * The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     */
    public val notificationPolicy: Output<String>?
        get() = javaResource.notificationPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Access Control List permission for S3 objects. Defaults to `private`.
     */
    public val objectAcl: Output<String>?
        get() = javaResource.objectAcl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
     */
    public val oplocksEnabled: Output<Boolean>
        get() = javaResource.oplocksEnabled().applyValue({ args0 -> args0 })

    /**
     * File share path used by the NFS client to identify the mount point.
     */
    public val path: Output<String>
        get() = javaResource.path().applyValue({ args0 -> args0 })

    /**
     * Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     */
    public val readOnly: Output<Boolean>?
        get() = javaResource.readOnly().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     */
    public val requesterPays: Output<Boolean>?
        get() = javaResource.requesterPays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
     */
    public val smbAclEnabled: Output<Boolean>?
        get() = javaResource.smbAclEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    public val validUserLists: Output<List<String>>?
        get() = javaResource.validUserLists().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The DNS name of the VPC endpoint for S3 private link.
     */
    public val vpcEndpointDnsName: Output<String>?
        get() = javaResource.vpcEndpointDnsName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object SmbFileShareMapper : ResourceMapper<SmbFileShare> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.SmbFileShare::class == javaResource::class

    override fun map(javaResource: Resource): SmbFileShare = SmbFileShare(
        javaResource as
            com.pulumi.aws.storagegateway.SmbFileShare,
    )
}

/**
 * @see [SmbFileShare].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SmbFileShare].
 */
public suspend fun smbFileShare(
    name: String,
    block: suspend SmbFileShareResourceBuilder.() -> Unit,
): SmbFileShare {
    val builder = SmbFileShareResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SmbFileShare].
 * @param name The _unique_ name of the resulting resource.
 */
public fun smbFileShare(name: String): SmbFileShare {
    val builder = SmbFileShareResourceBuilder()
    builder.name(name)
    return builder.build()
}
