@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.aws.storagegateway.SmbFileShareArgs.builder
import com.pulumi.aws.storagegateway.kotlin.inputs.SmbFileShareCacheAttributesArgs
import com.pulumi.aws.storagegateway.kotlin.inputs.SmbFileShareCacheAttributesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an AWS Storage Gateway SMB File Share.
 * ## Example Usage
 * ### Active Directory Authentication
 * > **NOTE:** The gateway must have already joined the Active Directory domain prior to SMB file share creationE.g., via "SMB Settings" in the AWS Storage Gateway console or `smb_active_directory_settings` in the `aws.storagegateway.Gateway` resource.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.SmbFileShare("example", {
 *     authentication: "ActiveDirectory",
 *     gatewayArn: exampleAwsStoragegatewayGateway.arn,
 *     locationArn: exampleAwsS3Bucket.arn,
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.SmbFileShare("example",
 *     authentication="ActiveDirectory",
 *     gateway_arn=example_aws_storagegateway_gateway["arn"],
 *     location_arn=example_aws_s3_bucket["arn"],
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.SmbFileShare("example", new()
 *     {
 *         Authentication = "ActiveDirectory",
 *         GatewayArn = exampleAwsStoragegatewayGateway.Arn,
 *         LocationArn = exampleAwsS3Bucket.Arn,
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewSmbFileShare(ctx, "example", &storagegateway.SmbFileShareArgs{
 * 			Authentication: pulumi.String("ActiveDirectory"),
 * 			GatewayArn:     pulumi.Any(exampleAwsStoragegatewayGateway.Arn),
 * 			LocationArn:    pulumi.Any(exampleAwsS3Bucket.Arn),
 * 			RoleArn:        pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.SmbFileShare;
 * import com.pulumi.aws.storagegateway.SmbFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SmbFileShare("example", SmbFileShareArgs.builder()
 *             .authentication("ActiveDirectory")
 *             .gatewayArn(exampleAwsStoragegatewayGateway.arn())
 *             .locationArn(exampleAwsS3Bucket.arn())
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:SmbFileShare
 *     properties:
 *       authentication: ActiveDirectory
 *       gatewayArn: ${exampleAwsStoragegatewayGateway.arn}
 *       locationArn: ${exampleAwsS3Bucket.arn}
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Guest Authentication
 * > **NOTE:** The gateway must have already had the SMB guest password set prior to SMB file share creationE.g., via "SMB Settings" in the AWS Storage Gateway console or `smb_guest_password` in the `aws.storagegateway.Gateway` resource.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.SmbFileShare("example", {
 *     authentication: "GuestAccess",
 *     gatewayArn: exampleAwsStoragegatewayGateway.arn,
 *     locationArn: exampleAwsS3Bucket.arn,
 *     roleArn: exampleAwsIamRole.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.SmbFileShare("example",
 *     authentication="GuestAccess",
 *     gateway_arn=example_aws_storagegateway_gateway["arn"],
 *     location_arn=example_aws_s3_bucket["arn"],
 *     role_arn=example_aws_iam_role["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.SmbFileShare("example", new()
 *     {
 *         Authentication = "GuestAccess",
 *         GatewayArn = exampleAwsStoragegatewayGateway.Arn,
 *         LocationArn = exampleAwsS3Bucket.Arn,
 *         RoleArn = exampleAwsIamRole.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewSmbFileShare(ctx, "example", &storagegateway.SmbFileShareArgs{
 * 			Authentication: pulumi.String("GuestAccess"),
 * 			GatewayArn:     pulumi.Any(exampleAwsStoragegatewayGateway.Arn),
 * 			LocationArn:    pulumi.Any(exampleAwsS3Bucket.Arn),
 * 			RoleArn:        pulumi.Any(exampleAwsIamRole.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.SmbFileShare;
 * import com.pulumi.aws.storagegateway.SmbFileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new SmbFileShare("example", SmbFileShareArgs.builder()
 *             .authentication("GuestAccess")
 *             .gatewayArn(exampleAwsStoragegatewayGateway.arn())
 *             .locationArn(exampleAwsS3Bucket.arn())
 *             .roleArn(exampleAwsIamRole.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:SmbFileShare
 *     properties:
 *       authentication: GuestAccess
 *       gatewayArn: ${exampleAwsStoragegatewayGateway.arn}
 *       locationArn: ${exampleAwsS3Bucket.arn}
 *       roleArn: ${exampleAwsIamRole.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_smb_file_share` using the SMB File Share Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/smbFileShare:SmbFileShare example arn:aws:storagegateway:us-east-1:123456789012:share/share-12345678
 * ```
 * @property accessBasedEnumeration The files and folders on this share will only be visible to users with read access. Default value is `false`.
 * @property adminUserLists A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
 * @property auditDestinationArn The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
 * @property authentication The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
 * @property bucketRegion The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
 * @property cacheAttributes Refresh cache information. see `cache_attributes` Block for more details.
 * **Note:** If you have previously included a `cache_attributes` block in your configuration, removing it will not reset the refresh cache value and the previous value will remain. You must explicitly set a new value to change it.
 * @property caseSensitivity The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
 * @property defaultStorageClass The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
 * @property fileShareName The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
 * @property gatewayArn Amazon Resource Name (ARN) of the file gateway.
 * @property guessMimeTypeEnabled Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
 * @property invalidUserLists A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
 * @property kmsEncrypted Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
 * @property kmsKeyArn Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
 * @property locationArn The ARN of the backed storage used for storing file data.
 * @property notificationPolicy The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
 * @property objectAcl Access Control List permission for S3 objects. Defaults to `private`.
 * @property oplocksEnabled Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
 * @property readOnly Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
 * @property requesterPays Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
 * @property roleArn The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
 * @property smbAclEnabled Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
 * @property tags Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property validUserLists A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
 * @property vpcEndpointDnsName The DNS name of the VPC endpoint for S3 private link.
 */
public data class SmbFileShareArgs(
    public val accessBasedEnumeration: Output<Boolean>? = null,
    public val adminUserLists: Output<List<String>>? = null,
    public val auditDestinationArn: Output<String>? = null,
    public val authentication: Output<String>? = null,
    public val bucketRegion: Output<String>? = null,
    public val cacheAttributes: Output<SmbFileShareCacheAttributesArgs>? = null,
    public val caseSensitivity: Output<String>? = null,
    public val defaultStorageClass: Output<String>? = null,
    public val fileShareName: Output<String>? = null,
    public val gatewayArn: Output<String>? = null,
    public val guessMimeTypeEnabled: Output<Boolean>? = null,
    public val invalidUserLists: Output<List<String>>? = null,
    public val kmsEncrypted: Output<Boolean>? = null,
    public val kmsKeyArn: Output<String>? = null,
    public val locationArn: Output<String>? = null,
    public val notificationPolicy: Output<String>? = null,
    public val objectAcl: Output<String>? = null,
    public val oplocksEnabled: Output<Boolean>? = null,
    public val readOnly: Output<Boolean>? = null,
    public val requesterPays: Output<Boolean>? = null,
    public val roleArn: Output<String>? = null,
    public val smbAclEnabled: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val validUserLists: Output<List<String>>? = null,
    public val vpcEndpointDnsName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.storagegateway.SmbFileShareArgs> {
    override fun toJava(): com.pulumi.aws.storagegateway.SmbFileShareArgs =
        com.pulumi.aws.storagegateway.SmbFileShareArgs.builder()
            .accessBasedEnumeration(accessBasedEnumeration?.applyValue({ args0 -> args0 }))
            .adminUserLists(adminUserLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .auditDestinationArn(auditDestinationArn?.applyValue({ args0 -> args0 }))
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .bucketRegion(bucketRegion?.applyValue({ args0 -> args0 }))
            .cacheAttributes(cacheAttributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .caseSensitivity(caseSensitivity?.applyValue({ args0 -> args0 }))
            .defaultStorageClass(defaultStorageClass?.applyValue({ args0 -> args0 }))
            .fileShareName(fileShareName?.applyValue({ args0 -> args0 }))
            .gatewayArn(gatewayArn?.applyValue({ args0 -> args0 }))
            .guessMimeTypeEnabled(guessMimeTypeEnabled?.applyValue({ args0 -> args0 }))
            .invalidUserLists(invalidUserLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .kmsEncrypted(kmsEncrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyArn(kmsKeyArn?.applyValue({ args0 -> args0 }))
            .locationArn(locationArn?.applyValue({ args0 -> args0 }))
            .notificationPolicy(notificationPolicy?.applyValue({ args0 -> args0 }))
            .objectAcl(objectAcl?.applyValue({ args0 -> args0 }))
            .oplocksEnabled(oplocksEnabled?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .requesterPays(requesterPays?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .smbAclEnabled(smbAclEnabled?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .validUserLists(validUserLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcEndpointDnsName(vpcEndpointDnsName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SmbFileShareArgs].
 */
@PulumiTagMarker
public class SmbFileShareArgsBuilder internal constructor() {
    private var accessBasedEnumeration: Output<Boolean>? = null

    private var adminUserLists: Output<List<String>>? = null

    private var auditDestinationArn: Output<String>? = null

    private var authentication: Output<String>? = null

    private var bucketRegion: Output<String>? = null

    private var cacheAttributes: Output<SmbFileShareCacheAttributesArgs>? = null

    private var caseSensitivity: Output<String>? = null

    private var defaultStorageClass: Output<String>? = null

    private var fileShareName: Output<String>? = null

    private var gatewayArn: Output<String>? = null

    private var guessMimeTypeEnabled: Output<Boolean>? = null

    private var invalidUserLists: Output<List<String>>? = null

    private var kmsEncrypted: Output<Boolean>? = null

    private var kmsKeyArn: Output<String>? = null

    private var locationArn: Output<String>? = null

    private var notificationPolicy: Output<String>? = null

    private var objectAcl: Output<String>? = null

    private var oplocksEnabled: Output<Boolean>? = null

    private var readOnly: Output<Boolean>? = null

    private var requesterPays: Output<Boolean>? = null

    private var roleArn: Output<String>? = null

    private var smbAclEnabled: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var validUserLists: Output<List<String>>? = null

    private var vpcEndpointDnsName: Output<String>? = null

    /**
     * @param value The files and folders on this share will only be visible to users with read access. Default value is `false`.
     */
    @JvmName("ghexobgccnybxvtl")
    public suspend fun accessBasedEnumeration(`value`: Output<Boolean>) {
        this.accessBasedEnumeration = value
    }

    /**
     * @param value A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("hsgopfinbwfltohn")
    public suspend fun adminUserLists(`value`: Output<List<String>>) {
        this.adminUserLists = value
    }

    @JvmName("iscvrcgpgqtmvihm")
    public suspend fun adminUserLists(vararg values: Output<String>) {
        this.adminUserLists = Output.all(values.asList())
    }

    /**
     * @param values A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("vlklhsuomabkyyqf")
    public suspend fun adminUserLists(values: List<Output<String>>) {
        this.adminUserLists = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
     */
    @JvmName("pgftvtkcqieyfytt")
    public suspend fun auditDestinationArn(`value`: Output<String>) {
        this.auditDestinationArn = value
    }

    /**
     * @param value The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
     */
    @JvmName("gwmvgpiamegnvvid")
    public suspend fun authentication(`value`: Output<String>) {
        this.authentication = value
    }

    /**
     * @param value The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
     */
    @JvmName("blkingovswsaenpu")
    public suspend fun bucketRegion(`value`: Output<String>) {
        this.bucketRegion = value
    }

    /**
     * @param value Refresh cache information. see `cache_attributes` Block for more details.
     * **Note:** If you have previously included a `cache_attributes` block in your configuration, removing it will not reset the refresh cache value and the previous value will remain. You must explicitly set a new value to change it.
     */
    @JvmName("lfrxivbyjkgrbeph")
    public suspend fun cacheAttributes(`value`: Output<SmbFileShareCacheAttributesArgs>) {
        this.cacheAttributes = value
    }

    /**
     * @param value The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     */
    @JvmName("bqqdgsyswjxxrbhd")
    public suspend fun caseSensitivity(`value`: Output<String>) {
        this.caseSensitivity = value
    }

    /**
     * @param value The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     */
    @JvmName("sflusvfjnsjiylrk")
    public suspend fun defaultStorageClass(`value`: Output<String>) {
        this.defaultStorageClass = value
    }

    /**
     * @param value The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     */
    @JvmName("vngmlqqyivuyucsc")
    public suspend fun fileShareName(`value`: Output<String>) {
        this.fileShareName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the file gateway.
     */
    @JvmName("oypqytmaenasytlk")
    public suspend fun gatewayArn(`value`: Output<String>) {
        this.gatewayArn = value
    }

    /**
     * @param value Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     */
    @JvmName("lgemycrycrqahqif")
    public suspend fun guessMimeTypeEnabled(`value`: Output<Boolean>) {
        this.guessMimeTypeEnabled = value
    }

    /**
     * @param value A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("wylkyautqyoogxqk")
    public suspend fun invalidUserLists(`value`: Output<List<String>>) {
        this.invalidUserLists = value
    }

    @JvmName("scgrddysalbqgutt")
    public suspend fun invalidUserLists(vararg values: Output<String>) {
        this.invalidUserLists = Output.all(values.asList())
    }

    /**
     * @param values A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("ivxfdwimcwpwkiup")
    public suspend fun invalidUserLists(values: List<Output<String>>) {
        this.invalidUserLists = Output.all(values)
    }

    /**
     * @param value Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     */
    @JvmName("rlnuxvwacjeaquwy")
    public suspend fun kmsEncrypted(`value`: Output<Boolean>) {
        this.kmsEncrypted = value
    }

    /**
     * @param value Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     */
    @JvmName("kwawvowpifpnwjsw")
    public suspend fun kmsKeyArn(`value`: Output<String>) {
        this.kmsKeyArn = value
    }

    /**
     * @param value The ARN of the backed storage used for storing file data.
     */
    @JvmName("wbqeesdklpcyfhns")
    public suspend fun locationArn(`value`: Output<String>) {
        this.locationArn = value
    }

    /**
     * @param value The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     */
    @JvmName("txfpsibiwputddfm")
    public suspend fun notificationPolicy(`value`: Output<String>) {
        this.notificationPolicy = value
    }

    /**
     * @param value Access Control List permission for S3 objects. Defaults to `private`.
     */
    @JvmName("gpgtubljduftnahv")
    public suspend fun objectAcl(`value`: Output<String>) {
        this.objectAcl = value
    }

    /**
     * @param value Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
     */
    @JvmName("ixxwrehwmsknpfpg")
    public suspend fun oplocksEnabled(`value`: Output<Boolean>) {
        this.oplocksEnabled = value
    }

    /**
     * @param value Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     */
    @JvmName("urgxrnctwyiaxaxr")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     */
    @JvmName("eausjifglvoixjhi")
    public suspend fun requesterPays(`value`: Output<Boolean>) {
        this.requesterPays = value
    }

    /**
     * @param value The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     */
    @JvmName("pyaxnumvivvojtki")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
     */
    @JvmName("kvmnsqgncdicokmv")
    public suspend fun smbAclEnabled(`value`: Output<Boolean>) {
        this.smbAclEnabled = value
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nymwpqkqopqmjxwg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("hvfrnpwoqykbtodv")
    public suspend fun validUserLists(`value`: Output<List<String>>) {
        this.validUserLists = value
    }

    @JvmName("hoxysadpbxpmmqyg")
    public suspend fun validUserLists(vararg values: Output<String>) {
        this.validUserLists = Output.all(values.asList())
    }

    /**
     * @param values A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("usuvfwbsbkqfbecs")
    public suspend fun validUserLists(values: List<Output<String>>) {
        this.validUserLists = Output.all(values)
    }

    /**
     * @param value The DNS name of the VPC endpoint for S3 private link.
     */
    @JvmName("sqtjoowndtgqdndm")
    public suspend fun vpcEndpointDnsName(`value`: Output<String>) {
        this.vpcEndpointDnsName = value
    }

    /**
     * @param value The files and folders on this share will only be visible to users with read access. Default value is `false`.
     */
    @JvmName("nodssadyimaerneb")
    public suspend fun accessBasedEnumeration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessBasedEnumeration = mapped
    }

    /**
     * @param value A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("tclrvaaowwmxqrkf")
    public suspend fun adminUserLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminUserLists = mapped
    }

    /**
     * @param values A list of users in the Active Directory that have admin access to the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("vctphadganroekhh")
    public suspend fun adminUserLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.adminUserLists = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the CloudWatch Log Group used for the audit logs.
     */
    @JvmName("ijaserapffhrxkpd")
    public suspend fun auditDestinationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auditDestinationArn = mapped
    }

    /**
     * @param value The authentication method that users use to access the file share. Defaults to `ActiveDirectory`. Valid values: `ActiveDirectory`, `GuestAccess`.
     */
    @JvmName("vmothynqvtkcbeqt")
    public suspend fun authentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The region of the S3 buck used by the file share. Required when specifying a `vpc_endpoint_dns_name`.
     */
    @JvmName("goapfpgrxtrsobak")
    public suspend fun bucketRegion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketRegion = mapped
    }

    /**
     * @param value Refresh cache information. see `cache_attributes` Block for more details.
     * **Note:** If you have previously included a `cache_attributes` block in your configuration, removing it will not reset the refresh cache value and the previous value will remain. You must explicitly set a new value to change it.
     */
    @JvmName("jxbjsraqwkqywlij")
    public suspend fun cacheAttributes(`value`: SmbFileShareCacheAttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cacheAttributes = mapped
    }

    /**
     * @param argument Refresh cache information. see `cache_attributes` Block for more details.
     * **Note:** If you have previously included a `cache_attributes` block in your configuration, removing it will not reset the refresh cache value and the previous value will remain. You must explicitly set a new value to change it.
     */
    @JvmName("yegmijcgnksnmsrw")
    public suspend fun cacheAttributes(argument: suspend SmbFileShareCacheAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = SmbFileShareCacheAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cacheAttributes = mapped
    }

    /**
     * @param value The case of an object name in an Amazon S3 bucket. For `ClientSpecified`, the client determines the case sensitivity. For `CaseSensitive`, the gateway determines the case sensitivity. The default value is `ClientSpecified`.
     */
    @JvmName("arfpnqlgflyxwbdx")
    public suspend fun caseSensitivity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caseSensitivity = mapped
    }

    /**
     * @param value The default [storage class](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-DefaultStorageClass) for objects put into an Amazon S3 bucket by the file gateway. Defaults to `S3_STANDARD`.
     */
    @JvmName("jscmahvuhgubcluo")
    public suspend fun defaultStorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultStorageClass = mapped
    }

    /**
     * @param value The name of the file share. Must be set if an S3 prefix name is set in `location_arn`.
     */
    @JvmName("bbkjemosuhqpkgby")
    public suspend fun fileShareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileShareName = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the file gateway.
     */
    @JvmName("epgifyxtydiillmy")
    public suspend fun gatewayArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayArn = mapped
    }

    /**
     * @param value Boolean value that enables guessing of the MIME type for uploaded objects based on file extensions. Defaults to `true`.
     */
    @JvmName("mndxjeiogqdydtwt")
    public suspend fun guessMimeTypeEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guessMimeTypeEnabled = mapped
    }

    /**
     * @param value A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("fldmncvbtsilwudf")
    public suspend fun invalidUserLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invalidUserLists = mapped
    }

    /**
     * @param values A list of users in the Active Directory that are not allowed to access the file share. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("cwdyaapnkrdjkhdu")
    public suspend fun invalidUserLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.invalidUserLists = mapped
    }

    /**
     * @param value Boolean value if `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Defaults to `false`.
     */
    @JvmName("skvwscbsbqqpfklb")
    public suspend fun kmsEncrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsEncrypted = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) for KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is true.
     */
    @JvmName("fwteptocdiyqrlks")
    public suspend fun kmsKeyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyArn = mapped
    }

    /**
     * @param value The ARN of the backed storage used for storing file data.
     */
    @JvmName("hpsdfnyxjihpkqvj")
    public suspend fun locationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.locationArn = mapped
    }

    /**
     * @param value The notification policy of the file share. For more information see the [AWS Documentation](https://docs.aws.amazon.com/storagegateway/latest/APIReference/API_CreateNFSFileShare.html#StorageGateway-CreateNFSFileShare-request-NotificationPolicy). Default value is `{}`.
     */
    @JvmName("rhqtjadjnihykkif")
    public suspend fun notificationPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationPolicy = mapped
    }

    /**
     * @param value Access Control List permission for S3 objects. Defaults to `private`.
     */
    @JvmName("catchsoonorrbguo")
    public suspend fun objectAcl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectAcl = mapped
    }

    /**
     * @param value Boolean to indicate Opportunistic lock (oplock) status. Defaults to `true`.
     */
    @JvmName("jtqtedvdnxycahvb")
    public suspend fun oplocksEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oplocksEnabled = mapped
    }

    /**
     * @param value Boolean to indicate write status of file share. File share does not accept writes if `true`. Defaults to `false`.
     */
    @JvmName("nqwkmculqylsdgad")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value Boolean who pays the cost of the request and the data download from the Amazon S3 bucket. Set this value to `true` if you want the requester to pay instead of the bucket owner. Defaults to `false`.
     */
    @JvmName("xymmlolscjyhbqik")
    public suspend fun requesterPays(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requesterPays = mapped
    }

    /**
     * @param value The ARN of the AWS Identity and Access Management (IAM) role that a file gateway assumes when it accesses the underlying storage.
     */
    @JvmName("lrwnpbmdmadnlmyd")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Set this value to `true` to enable ACL (access control list) on the SMB fileshare. Set it to `false` to map file and directory permissions to the POSIX permissions. This setting applies only to `ActiveDirectory` authentication type.
     */
    @JvmName("cxjrcbyuqsvxwmnq")
    public suspend fun smbAclEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smbAclEnabled = mapped
    }

    /**
     * @param value Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ljyffufyrkupldxu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cqsojjavpbkettmv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("gidvoprguofpvwxk")
    public suspend fun validUserLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.validUserLists = mapped
    }

    /**
     * @param values A list of users in the Active Directory that are allowed to access the file share. If you need to specify an Active directory group, add '@' before the name of the group. It will be set on Allowed group in AWS console. Only valid if `authentication` is set to `ActiveDirectory`.
     */
    @JvmName("pjsaxwxypwfloqqq")
    public suspend fun validUserLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.validUserLists = mapped
    }

    /**
     * @param value The DNS name of the VPC endpoint for S3 private link.
     */
    @JvmName("xufwasrcxnjktayn")
    public suspend fun vpcEndpointDnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointDnsName = mapped
    }

    internal fun build(): SmbFileShareArgs = SmbFileShareArgs(
        accessBasedEnumeration = accessBasedEnumeration,
        adminUserLists = adminUserLists,
        auditDestinationArn = auditDestinationArn,
        authentication = authentication,
        bucketRegion = bucketRegion,
        cacheAttributes = cacheAttributes,
        caseSensitivity = caseSensitivity,
        defaultStorageClass = defaultStorageClass,
        fileShareName = fileShareName,
        gatewayArn = gatewayArn,
        guessMimeTypeEnabled = guessMimeTypeEnabled,
        invalidUserLists = invalidUserLists,
        kmsEncrypted = kmsEncrypted,
        kmsKeyArn = kmsKeyArn,
        locationArn = locationArn,
        notificationPolicy = notificationPolicy,
        objectAcl = objectAcl,
        oplocksEnabled = oplocksEnabled,
        readOnly = readOnly,
        requesterPays = requesterPays,
        roleArn = roleArn,
        smbAclEnabled = smbAclEnabled,
        tags = tags,
        validUserLists = validUserLists,
        vpcEndpointDnsName = vpcEndpointDnsName,
    )
}
