@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [StoredIscsiVolume].
 */
@PulumiTagMarker
public class StoredIscsiVolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StoredIscsiVolumeArgs = StoredIscsiVolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StoredIscsiVolumeArgsBuilder.() -> Unit) {
        val builder = StoredIscsiVolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): StoredIscsiVolume {
        val builtJavaResource = com.pulumi.aws.storagegateway.StoredIscsiVolume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return StoredIscsiVolume(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway stored iSCSI volume.
 * > **NOTE:** The gateway must have a working storage added (e.g., via the `aws.storagegateway.WorkingStorage` resource) before the volume is operational to clients, however the Storage Gateway API will allow volume creation without error in that case and return volume status as `WORKING STORAGE NOT CONFIGURED`.
 * ## Example Usage
 * ### Create Empty Stored iSCSI Volume
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.StoredIscsiVolume("example", {
 *     gatewayArn: exampleAwsStoragegatewayCache.gatewayArn,
 *     networkInterfaceId: exampleAwsInstance.privateIp,
 *     targetName: "example",
 *     preserveExistingData: false,
 *     diskId: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.StoredIscsiVolume("example",
 *     gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
 *     network_interface_id=example_aws_instance["privateIp"],
 *     target_name="example",
 *     preserve_existing_data=False,
 *     disk_id=test["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.StoredIscsiVolume("example", new()
 *     {
 *         GatewayArn = exampleAwsStoragegatewayCache.GatewayArn,
 *         NetworkInterfaceId = exampleAwsInstance.PrivateIp,
 *         TargetName = "example",
 *         PreserveExistingData = false,
 *         DiskId = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewStoredIscsiVolume(ctx, "example", &storagegateway.StoredIscsiVolumeArgs{
 * 			GatewayArn:           pulumi.Any(exampleAwsStoragegatewayCache.GatewayArn),
 * 			NetworkInterfaceId:   pulumi.Any(exampleAwsInstance.PrivateIp),
 * 			TargetName:           pulumi.String("example"),
 * 			PreserveExistingData: pulumi.Bool(false),
 * 			DiskId:               pulumi.Any(test.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolume;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StoredIscsiVolume("example", StoredIscsiVolumeArgs.builder()
 *             .gatewayArn(exampleAwsStoragegatewayCache.gatewayArn())
 *             .networkInterfaceId(exampleAwsInstance.privateIp())
 *             .targetName("example")
 *             .preserveExistingData(false)
 *             .diskId(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:StoredIscsiVolume
 *     properties:
 *       gatewayArn: ${exampleAwsStoragegatewayCache.gatewayArn}
 *       networkInterfaceId: ${exampleAwsInstance.privateIp}
 *       targetName: example
 *       preserveExistingData: false
 *       diskId: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Create Stored iSCSI Volume From Snapshot
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.StoredIscsiVolume("example", {
 *     gatewayArn: exampleAwsStoragegatewayCache.gatewayArn,
 *     networkInterfaceId: exampleAwsInstance.privateIp,
 *     snapshotId: exampleAwsEbsSnapshot.id,
 *     targetName: "example",
 *     preserveExistingData: false,
 *     diskId: test.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.StoredIscsiVolume("example",
 *     gateway_arn=example_aws_storagegateway_cache["gatewayArn"],
 *     network_interface_id=example_aws_instance["privateIp"],
 *     snapshot_id=example_aws_ebs_snapshot["id"],
 *     target_name="example",
 *     preserve_existing_data=False,
 *     disk_id=test["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.StoredIscsiVolume("example", new()
 *     {
 *         GatewayArn = exampleAwsStoragegatewayCache.GatewayArn,
 *         NetworkInterfaceId = exampleAwsInstance.PrivateIp,
 *         SnapshotId = exampleAwsEbsSnapshot.Id,
 *         TargetName = "example",
 *         PreserveExistingData = false,
 *         DiskId = test.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewStoredIscsiVolume(ctx, "example", &storagegateway.StoredIscsiVolumeArgs{
 * 			GatewayArn:           pulumi.Any(exampleAwsStoragegatewayCache.GatewayArn),
 * 			NetworkInterfaceId:   pulumi.Any(exampleAwsInstance.PrivateIp),
 * 			SnapshotId:           pulumi.Any(exampleAwsEbsSnapshot.Id),
 * 			TargetName:           pulumi.String("example"),
 * 			PreserveExistingData: pulumi.Bool(false),
 * 			DiskId:               pulumi.Any(test.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolume;
 * import com.pulumi.aws.storagegateway.StoredIscsiVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new StoredIscsiVolume("example", StoredIscsiVolumeArgs.builder()
 *             .gatewayArn(exampleAwsStoragegatewayCache.gatewayArn())
 *             .networkInterfaceId(exampleAwsInstance.privateIp())
 *             .snapshotId(exampleAwsEbsSnapshot.id())
 *             .targetName("example")
 *             .preserveExistingData(false)
 *             .diskId(test.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:StoredIscsiVolume
 *     properties:
 *       gatewayArn: ${exampleAwsStoragegatewayCache.gatewayArn}
 *       networkInterfaceId: ${exampleAwsInstance.privateIp}
 *       snapshotId: ${exampleAwsEbsSnapshot.id}
 *       targetName: example
 *       preserveExistingData: false
 *       diskId: ${test.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_stored_iscsi_volume` using the volume Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/storedIscsiVolume:StoredIscsiVolume example arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678
 * ```
 */
public class StoredIscsiVolume internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.StoredIscsiVolume,
) : KotlinCustomResource(javaResource, StoredIscsiVolumeMapper) {
    /**
     * Volume Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/volume/vol-12345678`.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Whether mutual CHAP is enabled for the iSCSI target.
     */
    public val chapEnabled: Output<Boolean>
        get() = javaResource.chapEnabled().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the gateway local disk that is configured as a stored volume.
     */
    public val diskId: Output<String>
        get() = javaResource.diskId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the gateway.
     */
    public val gatewayArn: Output<String>
        get() = javaResource.gatewayArn().applyValue({ args0 -> args0 })

    /**
     * `true` to use Amazon S3 server side encryption with your own AWS KMS key, or `false` to use a key managed by Amazon S3. Optional.
     */
    public val kmsEncrypted: Output<Boolean>?
        get() = javaResource.kmsEncrypted().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3 server side encryption. This value can only be set when `kms_encrypted` is `true`.
     */
    public val kmsKey: Output<String>?
        get() = javaResource.kmsKey().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Logical disk number.
     */
    public val lunNumber: Output<Int>
        get() = javaResource.lunNumber().applyValue({ args0 -> args0 })

    /**
     * The network interface of the gateway on which to expose the iSCSI target. Only IPv4 addresses are accepted.
     */
    public val networkInterfaceId: Output<String>
        get() = javaResource.networkInterfaceId().applyValue({ args0 -> args0 })

    /**
     * The port used to communicate with iSCSI targets.
     */
    public val networkInterfacePort: Output<Int>
        get() = javaResource.networkInterfacePort().applyValue({ args0 -> args0 })

    /**
     * Specify this field as `true` if you want to preserve the data on the local disk. Otherwise, specifying this field as false creates an empty volume.
     */
    public val preserveExistingData: Output<Boolean>
        get() = javaResource.preserveExistingData().applyValue({ args0 -> args0 })

    /**
     * The snapshot ID of the snapshot to restore as the new stored volumeE.g., `snap-1122aabb`.
     */
    public val snapshotId: Output<String>?
        get() = javaResource.snapshotId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Key-value mapping of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Target Amazon Resource Name (ARN), e.g., `arn:aws:storagegateway:us-east-1:123456789012:gateway/sgw-12345678/target/iqn.1997-05.com.amazon:TargetName`.
     */
    public val targetArn: Output<String>
        get() = javaResource.targetArn().applyValue({ args0 -> args0 })

    /**
     * The name of the iSCSI target used by initiators to connect to the target and as a suffix for the target ARN. The target name must be unique across all volumes of a gateway.
     */
    public val targetName: Output<String>
        get() = javaResource.targetName().applyValue({ args0 -> args0 })

    /**
     * A value that indicates whether a storage volume is attached to, detached from, or is in the process of detaching from a gateway.
     */
    public val volumeAttachmentStatus: Output<String>
        get() = javaResource.volumeAttachmentStatus().applyValue({ args0 -> args0 })

    /**
     * Volume ID, e.g., `vol-12345678`.
     */
    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })

    /**
     * The size of the data stored on the volume in bytes.
     */
    public val volumeSizeInBytes: Output<Int>
        get() = javaResource.volumeSizeInBytes().applyValue({ args0 -> args0 })

    /**
     * indicates the state of the storage volume.
     */
    public val volumeStatus: Output<String>
        get() = javaResource.volumeStatus().applyValue({ args0 -> args0 })

    /**
     * indicates the type of the volume.
     */
    public val volumeType: Output<String>
        get() = javaResource.volumeType().applyValue({ args0 -> args0 })
}

public object StoredIscsiVolumeMapper : ResourceMapper<StoredIscsiVolume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.StoredIscsiVolume::class == javaResource::class

    override fun map(javaResource: Resource): StoredIscsiVolume = StoredIscsiVolume(
        javaResource as
            com.pulumi.aws.storagegateway.StoredIscsiVolume,
    )
}

/**
 * @see [StoredIscsiVolume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StoredIscsiVolume].
 */
public suspend fun storedIscsiVolume(
    name: String,
    block: suspend StoredIscsiVolumeResourceBuilder.() -> Unit,
): StoredIscsiVolume {
    val builder = StoredIscsiVolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StoredIscsiVolume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun storedIscsiVolume(name: String): StoredIscsiVolume {
    val builder = StoredIscsiVolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
