@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.storagegateway.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TapePool].
 */
@PulumiTagMarker
public class TapePoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TapePoolArgs = TapePoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TapePoolArgsBuilder.() -> Unit) {
        val builder = TapePoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TapePool {
        val builtJavaResource = com.pulumi.aws.storagegateway.TapePool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TapePool(builtJavaResource)
    }
}

/**
 * Manages an AWS Storage Gateway Tape Pool.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.storagegateway.TapePool("example", {
 *     poolName: "example",
 *     storageClass: "GLACIER",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.storagegateway.TapePool("example",
 *     pool_name="example",
 *     storage_class="GLACIER")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.StorageGateway.TapePool("example", new()
 *     {
 *         PoolName = "example",
 *         StorageClass = "GLACIER",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/storagegateway"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storagegateway.NewTapePool(ctx, "example", &storagegateway.TapePoolArgs{
 * 			PoolName:     pulumi.String("example"),
 * 			StorageClass: pulumi.String("GLACIER"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.storagegateway.TapePool;
 * import com.pulumi.aws.storagegateway.TapePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TapePool("example", TapePoolArgs.builder()
 *             .poolName("example")
 *             .storageClass("GLACIER")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:storagegateway:TapePool
 *     properties:
 *       poolName: example
 *       storageClass: GLACIER
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_storagegateway_tape_pool` using the volume Amazon Resource Name (ARN). For example:
 * ```sh
 * $ pulumi import aws:storagegateway/tapePool:TapePool example arn:aws:storagegateway:us-east-1:123456789012:tapepool/pool-12345678
 * ```
 */
public class TapePool internal constructor(
    override val javaResource: com.pulumi.aws.storagegateway.TapePool,
) : KotlinCustomResource(javaResource, TapePoolMapper) {
    /**
     * Volume Amazon Resource Name (ARN), e.g., `aws_storagegateway_tape_pool.example arn:aws:storagegateway:us-east-1:123456789012:tapepool/pool-12345678`.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The name of the new custom tape pool.
     */
    public val poolName: Output<String>
        get() = javaResource.poolName().applyValue({ args0 -> args0 })

    /**
     * Tape retention lock time is set in days. Tape retention lock can be enabled for up to 100 years (36,500 days). Default value is 0.
     */
    public val retentionLockTimeInDays: Output<Int>?
        get() = javaResource.retentionLockTimeInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Tape retention lock can be configured in two modes. When configured in governance mode, AWS accounts with specific IAM permissions are authorized to remove the tape retention lock from archived virtual tapes. When configured in compliance mode, the tape retention lock cannot be removed by any user, including the root AWS account. Possible values are `COMPLIANCE`, `GOVERNANCE`, and `NONE`. Default value is `NONE`.
     */
    public val retentionLockType: Output<String>?
        get() = javaResource.retentionLockType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage class that is associated with the new custom pool. When you use your backup application to eject the tape, the tape is archived directly into the storage class that corresponds to the pool. Possible values are `DEEP_ARCHIVE` or `GLACIER`.
     */
    public val storageClass: Output<String>
        get() = javaResource.storageClass().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object TapePoolMapper : ResourceMapper<TapePool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.storagegateway.TapePool::class == javaResource::class

    override fun map(javaResource: Resource): TapePool = TapePool(
        javaResource as
            com.pulumi.aws.storagegateway.TapePool,
    )
}

/**
 * @see [TapePool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TapePool].
 */
public suspend fun tapePool(name: String, block: suspend TapePoolResourceBuilder.() -> Unit): TapePool {
    val builder = TapePoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TapePool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun tapePool(name: String): TapePool {
    val builder = TapePoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
